#!/usr/bin/env bash
g=2
bdim=2
for seed in 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
do
    for rnn in lstm gru o2rnn mirnn
    do
        for mdim in 1 2 3 4 5
        do  
            sdim=$((bdim*mdim))
            echo "==================================================================================="
            echo "=  seed : ${seed}  model : ${rnn}  grammar : ${g}  sdim : ${sdim}"
            echo "==================================================================================="
            CUDA_VISIBLE_DEVICES=0 python rnn2dfa_lstar.py \
                --suffix "${rnn}_g${g}_sdim_${sdim}_es_${es}" \
                --seed $seed \
                --state_dim $sdim \
                --load_model "../models/dfa_stability_rnn_${rnn}_tomita_g${g}_sdim_${sdim}_es_${es}_bce_seed_${seed}/best.pth" \
                --model "rnn" \
                --rnn_cell $rnn \
                --hinit 1 \
                --mtype "classification" \
                --dropout 0 \
                --nlayers 1 \
                --dataset "MSI" \
                --grammar "tomita-${g}" \
                --batch_size 2000 \
                --remove_start \
                --remove_end \
                --shuffle_data
        done
    done
done
