#!/usr/bin/env bash
g=1
bdim=2
mdim=2
for model in lstm gru o2rnn mirnn
do
    for seed in 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
    do
        for nbin in 0 1
        do
            for es in 0.85
            do
                for cluster in kmeans som
                do
                    sdim=$((bdim*mdim))
                    echo "======================================================================="
                    echo "model : ${model} seed : ${seed} state_dim : ${sdim} test bin : ${nbin}"
                    echo "======================================================================="

                    CUDA_VISIBLE_DEVICES=2 python test_dfa.py \
                        --suffix "tomita_g${g}_sdim_${sdim}_bce" \
                        --dfa_path "../dfa/dfa_rnn_${model}_g${g}_sdim_${sdim}_es_${es}_${cluster}_seed_${seed}_ns.dfa" \
                        --seed $seed \
                        --state_dim $sdim\
                        --model "rnn" \
                        --rnn_cell $model \
                        --mtype "classification" \
                        --grammar "tomita-${g}"\
                        --dtype "test" \
                        --nbin $nbin \
                        --dataset "MSI"\
                        --cluster_method $cluster \
                        --result_file "../results/dfa_${es}/g${g}_${model}_sdim_${sdim}_es_${es}_${cluster}_nbin_${nbin}.json" \
                        --remove_start \
                        --remove_end 
                done
            done
        done 
    done
done
