#!/usr/bin/env bash
g=8
bdim=8
# 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
for seed in 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
do
    for rnn in lstm gru o2rnn mirnn
    do
        for mdim in 1 2 3 4 5
        do
            sdim=$((bdim*mdim))
            echo "==================================================================================="
            echo "=  seed : ${seed}  model : ${rnn}  grammar : ${g}  sdim : ${sdim}"
            echo "==================================================================================="
            CUDA_LAUNCH_BLOCKING=1 CUDA_VISIBLE_DEVICES=1 python train.py \
                --suffix "dyck_${g}_sdim_${sdim}_bce" \
                --iterations 15000 \
                --save_model_iter 1000\
                --batch_size 2048 \
                --seed $seed \
                --state_dim $sdim\
                --lr 0.01 \
                --model "rnn" \
                --rnn_cell $rnn \
                --mtype "classification" \
                --grammar "dyck-${g}"\
                --dropout 0 \
                --nlayers 1 \
                --l1_lambda 0 \
                --hinit 1 \
                --valid_iter 100 \
                --stopping_patience 20 \
                --dataset "dyck_${g}_50"\
                --optim "sgd" \
                --loss_func "bce" \
                --lr_scheduler "one_cycle_lr" \
                --print_iter 10
        done
    done
done
