#!/usr/bin/env bash
for seed in 4240 1136 8204 6264 8634
do
CUDA_VISIBLE_DEVICES=0 python train.py \
    --suffix "tomita_g1_sdim_2_bce" \
    --load_iter -1 \
    --iterations 5000 \
    --save_model_iter 100000\
    --batch_size 1024 \
    --seed $seed \
    --state_dim 2\
    --lr 0.01 \
    --model "o2rnn" \
    --mtype "classification" \
    --grammar "tomita-1"\
    --valid_bin 0 \
    --dropout 0 \
    --nlayers 1 \
    --l1_lambda 0 \
    --valid_iter 100 \
    --dataset "MSI"\
    --optim "adam" \
    --vocab "vocab" \
    --loss_func "bce" \
    --partial_strings 
done 

for seed in 1646 3199 6735 3933 1470
do
CUDA_VISIBLE_DEVICES=1 python train.py \
    --suffix "tomita_g1_sdim_2_bce" \
    --load_iter -1 \
    --iterations 5000 \
    --save_model_iter 100000\
    --batch_size 1024 \
    --seed $seed \
    --state_dim 2\
    --lr 0.01 \
    --model "o2rnn" \
    --mtype "classification" \
    --grammar "tomita-1"\
    --valid_bin 0 \
    --dropout 0 \
    --nlayers 1 \
    --l1_lambda 0 \
    --valid_iter 100 \
    --dataset "MSI"\
    --optim "adam" \
    --vocab "vocab" \
    --loss_func "bce" \
    --partial_strings 
done 

