#!/usr/bin/env bash
g=7
bdim=5
mdim=2
for seed in 4240 1136 8204 6264 8634 1646 3199 6735 3933 1470
do
    for rnn in lstm gru o2rnn mirnn
    do
        for es in 0.85
        do
            sdim=$((bdim*mdim))
            echo "==================================================================================="
            echo "=  seed : ${seed}  model : ${rnn}  grammar : ${g}  sdim : ${sdim}"
            echo "==================================================================================="
            CUDA_LAUNCH_BLOCKING=1 CUDA_VISIBLE_DEVICES=3 python train.py \
                --suffix "tomita_g${g}_sdim_${sdim}_es_${es}_bce" \
                --iterations 15000 \
                --save_model_iter 1000\
                --batch_size 2048 \
                --seed $seed \
                --state_dim $sdim\
                --lr 0.01 \
                --model "rnn" \
                --rnn_cell $rnn \
                --mtype "classification" \
                --grammar "tomita-${g}"\
                --dropout 0 \
                --nlayers 1 \
                --l1_lambda 0 \
                --hinit 1 \
                --valid_iter 1 \
                --stopping_patience 1000 \
                --dataset "MSI"\
                --optim "sgd" \
                --loss_func "bce" \
                --lr_scheduler "one_cycle_lr" \
                --early_stop $es \
                --partial_strings 
        done
    done
done