## Hypergraph Convolutional Networks via Equivalency between Hypergraphs and Undirected Graphs

Supplement materials (Code) of ICLR 2022 Conference Blind Submission. Part of the experimental results of Generalized Hypergraph Convolutional Network (GHCN) and Simple Hypergraph Spectral Convolution (SHSC) as follows. 
## Installation
The main dependency packages are:

python 3.8.6; 
pytorch 1.6.0;  
scipy 1.6.0.

The complete environment can be installed on anaconda by 
`conda env create -f`
 [environment.yaml](environment.yaml).
## 1. Citation network classification
### GHCN
To train and evaluate GHCN on dataset cocitation/pubmed:


```
python train.py --data_path ./data --save_dir ./model/hgnn --print_freq 100 --epochs 1000 --hidden 128 --gpu 2 --type ghcn --split 1 --dropout 0.5 --weight_decay 0.0005 --sigma -1 --nbaseblocklayer 2 --activate_dataset cocitation/pubmed
```


mean+-std: 0.75366+-0.01229,

### SHSC

To train and evaluate SHSC on dataset cocitation/cora:
```
python train.py --activate_dataset cocitation/cora --data_path ./data --print_freq 100 --epochs 1000 --gpu 3 --type shsc --split 1 --alpha 0.93 --beta 1.0 --lr 0.01 --weight_decay 0.001 --dropout 0.2 --sigma -0.5 --degree 32
```


mean+-std:0.706438+-0.018657


## 2. Visual object classification
Following [HGNN](http://gaoyue.org/paper/HGNN.pdf), the datasets can download as blow for training/evaluation  (should be placed under "data_path")
- [ModelNet40_mvcnn_gvcnn_feature](https://drive.google.com/file/d/1euw3bygLzRQm_dYj1FoRduXvsRRUG2Gr/view?usp=sharing)
- [NTU2012_mvcnn_gvcnn_feature](https://drive.google.com/file/d/1Vx4K15bW3__JPRV0KUoDWtQX8sB-vbO5/view?usp=sharing)



### GHCN
To train and evaluate GHCN on ModelNet40 with MVCNN+GVCNN (BOTH) structures and MVCNN+GVCNN (BOTH) features.
```
python train.py --data_path ./data --on_dataset ModelNet40 --gvcnn_feature_structure --mvcnn_feature_structure --use_gvcnn_feature --use_mvcnn_feature --save_dir model/hgnn/gvcnn --is_probH --epochs 1000 --seed 1000 --hidden 128 --print_freq 100 --nhiddenlayer 1 --nbaseblocklayer 2 --dropout 0.5 --gpu 3 --type ghcn --K_neigs 6 --sigma -1 --lr 0.001 --gamma 0.5 --weight_decay 0.001
```

10 random seed(1000-1009): [0.9704213938411669, 0.9732576985413289, 0.9720421393841167, 0.9716369529983792, 0.9716369529983792, 0.9744732576985413, 0.9732576985413289, 0.9752836304700162, 0.9740680713128038, 0.9716369529983792]


mean+-std: 0.97277+-0.00146  


### SHSC
To train and evaluate SHSC on  ModelNet40 with MVCNN+GVCNN (BOTH) structures and MVCNN+GVCNN (BOTH) features.

```
python train.py --data_path ./data --on_dataset ModelNet40 --gvcnn_feature_structure --mvcnn_feature_structure --use_gvcnn_feature --use_mvcnn_feature --save_dir ./model --gamma 0.5 --epochs 1000 --seed 1000 --K_neigs 6 --print_freq 100 --nhiddenlayer 1 --lr 0.001 --dropout 0.5 --gpu 1 --type shsc --degree 16 --alpha 0.92 --sigma -1 --is_probH --weight_decay 0.000001 --beta 0.8
```

10 random seed(1000-1009): [0.9781199351701783, 0.9777147487844408, 0.9777147487844408, 0.9785251215559156, 0.9777147487844408, 0.9773095623987034, 0.9777147487844408, 0.9773095623987034, 0.9777147487844408, 0.9777147487844408]


mean+-std: 0.97776 +- 0.00034
