# Dual-AN
This is the offcial repository of paper "Dual-AN: A Hierarchical Framework Synergizes Frequency and Time Domain for Non-stationary Time Series Forecasting"



![image](https://github.com/XinhuaMiao/Dual-AN/blob/main/fig/Overview%20of%20Dual-AN.png)

# 1. Datasets

We have prepared all the 8 datasets including ETTh1, ETTh2, ETTm1, ETTm2, Electricity, Exchange, Traffic, and Weather under the folder `./data`, and the details of the datasets are shown in the following table:
  
| Datasets    | Dim | Dataset Size          | Frequency  | K  | Trend Variation | Seasonality Variation | Information     |
|:-------------:|:-----:|:-----------------------:|:------------:|:----:|:-----------------:|:-----------------------:|:-----------------:|
| ETTh1       | 7   | (8545, 2881, 2881)    | 1 Hour     | 4  | 3.839           | 3.690                 | Temperature     |
| ETTh2       | 7   | (8545, 2881, 2881)    | 1 Hour     | 3  | 0.154           | 1.013                 | Temperature     |
| ETTm1       | 7   | (34465, 11521, 11521) | 15 Minutes | 11 | 0.030           | 3.330                 | Temperature     |
| ETTm2       | 7   | (34465, 11521, 11521) | 15 Minutes | 5  | 0.196           | 1.648                 | Temperature     |
| Electricity | 321 | (18317, 2633, 5261)   | 1 Hour     | 2  | 0.249           | 0.435                 | Electricity     |
| Exchange    | 8   | (5120, 665, 1422)     | 1 Day      | 3  | 0.242           | 2.645                 | Exchange Rate   |
| Traffic     | 862 | (12185, 1757, 3509)   | 1 Hour     | 30 | 0.068           | 14.225                | Transportation  |
| Weather     | 21  | (36792, 5271, 10540)  | 10 Minutes | 2  | 0.028           | 0.387                 | Weather         |

# 2. Preparation

## 2.1 install requirements

1. to run our code, **Please make sure your python version is >=3.8.**
2. install all the requirements, we assume that you have installed torch according to your environment:
```
pip install -r ./requirements.txt
```

3. Please first source this init.sh script:

```
source ./init.sh 
```

or manually add this directory to your PATHONPATH environment variable:

```
export PYTHONPATH=./
```

# 3. Train and Evaluation

## 3.1 Dual-AN


Please change the settings in the following for what you need.
```python
# running Dual-AN using DLinear backbone with output length 96, 168, 336, 720 on dataset ETTh1 with input window 96, and hyperparameter k = 4
bach ./scripts/run_dualan.sh "DLinear" "DualAN"  "ETTh1" "96 168 336 720"  "cuda:0" 96  "{freq_topk:4}"
```

## 3.2 FAN

Please change the settings in the following for what you need.
```python
# running FAN using Dlinear backbone with output length 96, 168, 336, 720 on dataset ETTh1 with input window 96, and hyperparameter k = 4
bash ./scripts/run_dualan.sh "DLinear" "FAN" "ETTh1" "96 168 336 720"  "cuda:0" 96  "{freq_topk:4}"
```

## 3.3 Other Baselines
Please change the settings in the following for what you need.
```python
# running all other baselines (DLinear backbone) with output length 96, 168, 336, 720 on dataset ETTh1 ETTh2 with input window 96
bash ./scripts/run.sh "DLinear" "No RevIN DishTS SAN" "ETTh1 ETTh2" "96 168 336 720"  "cuda:0" 96
```

## 3.4 Wandb Tool
If you want to use the **wandb** tool, please change run_dualan.sh to run_dualan_wandb.sh:

```python
# running Dual-AN using Dlinear backbone with output length 96, 168, 336, 720 on dataset ETTh1 with input window 96, and hyperparameter k = 4
bash ./scripts/run_dualan_wandb.sh "DLinear" "DualAN" "ETTh1" "96 168 336 720"  "cuda:0" 96  "{freq_topk:4}"
```

or change run.sh to run_wandb.sh:

```python
# running Dual-AN using Dlinear backbone with output length 96, 168, 336, 720 on dataset ETTh1 ETTh2 with input window 96, and hyperparameter k = 4
bash ./scripts/run_wandb.sh "DLinear" "No RevIN DishTS SAN" "ETTh1 ETTh2" "96 168 336 720"  "cuda:0" 96
```

# 4. Results

We summarize the main experimental results as follows:

![image](https://github.com/XinhuaMiao/Dual-AN/blob/main/fig/Results%20of%20Table%206.png)

![image](https://github.com/XinhuaMiao/Dual-AN/blob/main/fig/Results%20of%20Table%207.png)
