#!/usr/bin/env python3
# -*- coding: utf-8 -*-



DEFAULT_MODEL = "gpt-4o"
DEFAULT_TEMPERATURE = 0.0
DEFAULT_MAX_TOKENS = 2000


DEFAULT_THRESHOLD = 0.8
DEFAULT_QUESTION = "Evaluate the quality of the knowledge graph extracted from the academic paper"


DIMENSION_WEIGHTS = {
    "domain_fit": 0.20,      
    "accuracy": 0.20,         
    "consistency": 0.20,    
    "completeness": 0.20,    
    "granularity": 0.20     
}


DEFAULT_OUTPUT_SUFFIX = "_evaluation.json"
DEFAULT_ENCODING = "utf-8"


LOG_FORMAT = "%(asctime)s - %(name)s - %(levelname)s - %(message)s"
LOG_LEVEL = "INFO"


TURTLE_BLOCK_START = "```turtle"
TURTLE_BLOCK_END = "```"
SECTION_PATTERN = r'# ===== SECTION: ([^=]+) ====='
SOURCE_SECTION_PATTERN = r':sourceSection\s+"([^"]+)"'
EXPECTED_ENTITY_TYPES = [
    "Author", "Model", "Language", "Method", "Task", 
    "Organization", "Publication", "Concept", "Dataset",
    "Metric", "Component", "Architecture", "Tool"
]

EXPECTED_RELATION_TYPES = [
    "rdf:type", "partOf", "uses", "trainedOn", "evaluatedOn",
    "appliedTo", "relatedTo", "partiallyOrthogonalTo", "mappedTo",
    "usedFor", "contributesTo", "addresses", "shows"
]


MIN_TRIPLES_PER_SECTION = 5
MIN_ENTITIES_PER_SECTION = 3
MAX_REDUNDANCY_RATE = 0.3
MIN_EVIDENCE_COVERAGE = 0.6


PROMPT_VARIABLES = [
    "QUESTION",
    "ONTOLOGY_OR_RULES", 
    "SECTIONED_TURTLE_BLOCK"
]