import argparse

from main import Run_Exp

parser = argparse.ArgumentParser()

# config
parser.add_argument('--DATAPATH', type=str, default='./data/')
parser.add_argument('--dataset', type=str, choices=['cora', 'citeseer', 'pubmed', 'chameleon', 'squirrel', 'actor', 'texas', 'cornell'], default='chameleon')
parser.add_argument('--sub_dataset', type=str, choices=['', 'DE'], default='')
parser.add_argument('--sl_mode', type=str, choices=['semi', 'full'], default='full')
parser.add_argument('--rnd_seed', type=int, default=123456, help='seed.')

# fixed hyper-parameters
parser.add_argument('--hidden_channels', type=int, default=64, help='hidden units.')
parser.add_argument('--nepoch', type=int, default=1000, help='max epochs.')
parser.add_argument('--early', type=int, default=200, help='early stopping.')
parser.add_argument('--cpu', type=bool, default=False, help='use cpu or not.')
parser.add_argument('--is_print', type=bool, default=False, help='print the training process or not.')

# tuned hyper-parameters for spectral filtering (base model)
parser.add_argument('--reg', type=float, default=1e-4, help='weight decay.')
parser.add_argument('--lr', type=float, default=1e-2, help='learning rate.')
parser.add_argument('--dropout', type=float, default=0.5, help='dropout for linear mapping.')
parser.add_argument('--filter_wd', type=float, default=1e-4, help='weight decay for filter weights.')
parser.add_argument('--filter_lr', type=float, default=1e-2, help='learning rate for filter weights.')
parser.add_argument('--dprate', type=float, default=0.5, help='dropout for filter weights.')

# tuned hyper-parameters for non-local aggregation (ours)
parser.add_argument('--ama_wd', type=float, default=1e-4, help='weight decay for node-wise Amalgamation.')
parser.add_argument('--ama_lr', type=float, default=1e-2, help='learning rate for node-wise Amalgamation.')
parser.add_argument('--drop_ama', type=float, default=0.5, help='dropout for node-wise Amalgamation.')
parser.add_argument('--agg_alpha', type=float, default=0.5, help='update rate for non-local aggregation.')
parser.add_argument('--agg_K', type=int, default=5, help='aggregation steps for non-local aggregation.')
parser.add_argument('--scale', type=float, default=1.0, help='scaling parameter for constructing the new non-local graph.')
parser.add_argument('--eps', type=float, default=1e-3, help='threshold for sparsing the dense non-local graph.')

args = parser.parse_args()

Run_Exp(args)
