## Rethinking Spectral Graph Neural Networks with Spatially Adaptive Filtering

This repository contains a PyTorch implementation of the work "Rethinking Spectral Graph Neural Networks with Spatially Adaptive Filtering".


## Environment Settings    
- pytorch 1.8.0
- numpy 1.19.5
- torch-geometric 1.7.2
- scipy 1.5.3
- seaborn 0.11.2
- sklearn 0.24.2
- pickle 4.0


## Datasets
We provide two datasets in the folder './data'. Other datasets can be downloaded through the links provided in the Appendix.


## Code Structure
Running the below script for preprocessing datasets in the folder './data/raw/' (the preprocessed data will be saved in the folders './data/processed' and './data/eigen_dcp').
```
python preprocessing.py
```
Running the below script for reproducing the semi-supervised node classification results.
```sh
sh semi_rnd.sh
```
Running the below script for reproducing the full-supervised node classification results.
```sh
sh full_rnd.sh
```
