def get_pred_path(config, model_name, max_length, do_sample, dataset):
    sample_path = "_do_sample" if do_sample else ""
    if config.method == "origin":
        out_path = f"longbench_pred/{model_name}_{max_length}{sample_path}/{dataset}.jsonl"
    elif config.method == "kivi":
        out_path = f"longbench_pred/{model_name}_{max_length}_{config.k_bits}_{config.v_bits}_{config.group_size}_{config.residual_length}_{config.nsamples}{sample_path}/{dataset}.jsonl"
    else:
        out_path = f"longbench_pred/{model_name}_{max_length}_{config.k_rank}_{config.k_high_rank}_{config.sparse_rank}_{config.sparsity}_{config.v_bits}_{config.group_size}_{config.residual_length}_{config.nsamples}_{config.skip_layers}_{config.withsoftmax}_{config.topk_rank}_{config.budget}{sample_path}/{dataset}.jsonl"
    return out_path