#!/bin/bash
taskTwoDigit=$1
taskNum=$1

while [[ ${#taskTwoDigit} -lt 2 ]] ; do
    taskTwoDigit="0${taskTwoDigit}"
done

trainPath="train"
evalPath="test"
seqDataPath="ProceL_labels.pkl.npy"
cpRoot="results/checkpoint"
tbRoot="results/tensorboard"
taskList="assemble_clarinet change_tire perform_cpr setup_chromecast change_toilet_seat make_pbj_sandwich jump_car tie_tie change_iphone_battery"
taskArray=($taskList)
echo "Number of elements in the array: ${#taskArray[@]}"


fixedStr="CUDA_VISIBLE_DEVICES=$taskNum python main.py \
--train_path=$trainPath \
--eval_path=$evalPath \
--seq_data_path=$seqDataPath \
--cp_root=$cpRoot \
--tb_root=$tbRoot \
--dataset_name=ProceL \
--pin_memory \
--dist_url='tcp://127.0.0.1:512$taskTwoDigit' \
--evaluate \
--with_text \
--world_size=1 \
--rank=0 \
--gpu=0 \
--text_att_type=4 \
--lr=0.0003 \
--epochs=600 \
--next_step_pred \
--num_layers=24 --text_feedforward_dim=512 --hidden_dim=1024 --train_batch_size=32 --eval_batch_size=32"



cmd="$fixedStr \
     --task_name=${taskArray[taskNum]}"
printf "\n\n\nRunning...\n\n"
printf "<=================================================>\n"
printf "<=================================================>\n"
printf "\n\n$cmd\n\n"
printf "<=================================================>\n"
printf "<=================================================>\n"
eval $cmd
