# Aug-ILA
This is the code for the ICLR2022 Paper: \
Aug-ILA: More Transferable Intermediate Level Attacks with Augmented References

## Environments
The experiments in the paper are conducted under the following environment:
* Python 3.8.5
* Numpy 1.19.2
* Pillow 8.0.0
* PyTorch 1.9.0
* Torchvision 0.10.0

## Datasets

The ImageNet validation dataset should be prepared into the following structure:
```
aug-ila
└───data
    ├── selected_imagenet_full.csv
    └── ILSVRC2012_img_val
        ├── n01440764
        │   ├── ILSVRC2012_val_00000293.JPEG
        │   └── ...
        ├── n01443537
        │   ├── ILSVRC2012_val_00000236.JPEG
        │   └── ...
        ...
        .            
        └── n15075141
```
`ILSVRC2012_img_val` is a folder containing 1000 subfolders, corresponding to the 1000 ImageNet classes. Each subfolder contains all valiation images belonging to that class.

`selected_imagenet_full.csv` should be in the following format:
```
n01440764,ILSVRC2012_val_00045866.JPEG,...
n01443537,ILSVRC2012_val_00013623.JPEG,...
...
```
The first column is the name of the folders (can be in any format as long as it matches with the folder names), the remaining columns are the names of all selected images inside. It is fine for the rows to have different number of separated values.

## Attack


```
python attack.py -h
usage: attack.py [-h] [--batch_size BATCH_SIZE] [--epsilon EPSILON]
                 [--max_batch MAX_BATCH] [--save_dir SAVE_DIR] [-m MODEL_TYPE]
                 [--niters NITERS] [--ila ILA] [--ila_layer ILA_LAYER]
                 [--step_size STEP_SIZE] [--pgd] [-a ALPHA] [--aug AUG]

For Generation of Transferrable Attack

optional arguments:
  -h, --help            show this help message and exit
  --batch_size BATCH_SIZE
  --epsilon EPSILON     The perturbation budget
  --max_batch MAX_BATCH
                        The number of batch to stop early (default: -1 = not
                        to stop)
  --save_dir SAVE_DIR   The path to save the output tensors for validation
  -m MODEL_TYPE, --model_type MODEL_TYPE
                        resnet50/vgg19/inception_v3
  --niters NITERS       The number of attack iteration
  --ila ILA             The number of ILA iteration after the attack
                        generation
  --ila_layer ILA_LAYER
                        The layer to perform ILA (note the format is different
                        for different model)
  --step_size STEP_SIZE
                        The step size of both I-FGSM and ILA
  --pgd                 to activate random initialization (PGD)
  -a ALPHA, --alpha ALPHA
                        The alpha value for attack interpolation (< 0 for
                        being adaptive)
  --aug AUG             t/c/r/j/a (traslation/cropping/rotation/color
                        jitter/adversarial)
```

To generate an I-FGSM (10 iters) + Aug-ILA (50 iters) attack at layer '3-1' of ResNet50 with $\epsilon = 0.03$:
```
python attack.py
```
The command above is equivalent to:
```
python attack.py --epsilon 0.03 --batch_size 100 --niters 10 --ila 50 -m resnet50 --ila_layer 3_1 --aug ac --alpha -1
```
By default, the adversarial examples will be saved into `data/attack_batches/bs100_eps0.03_resnet50_niters10_ila50_l3_1_alpha-1.0_augac` (folder name will depend on input arguments) as batched PyTorch tensors.

To perform a standard ILA without any augmentation at layer 9 of VGG19 with $\epsilon = 0.05$, run
```
python attack.py --epsilon 0.05 -m vgg19 --ila_layer 9 --aug _ --alpha 0
```


## Test the Attack Transferability

```
usage: test.py [-h] [--models MODELS] [--batch_size BATCH_SIZE] [-f FOLDER]
               [-b] [-q] [--max_batch MAX_BATCH] [--load_dir LOAD_DIR]

For Testing Attack Transferability

optional arguments:
  -h, --help            show this help message and exit
  --models MODELS       dict_keys(['resnet50', 'wrn50_2', 'inception_v3',
                        'vgg19', 'pnasnet5', 'densenet', 'mobilenet',
                        'resnext101', 'senet50'])
  --batch_size BATCH_SIZE
                        only useful for tests with clean (benign) images
  -f FOLDER, --folder FOLDER
                        the folder to test on
  -b, --benign          whether to test on benign image only
  -q, --quiet           only report the summary
  --max_batch MAX_BATCH
                        the number of batch to break early (default = -1)
  --load_dir LOAD_DIR   The path to load the output tensors for testing
```

To test the adversarial examples generated from Aug-ILA in the previous section on all 9 models, run
```
python test.py -f bs100_eps0.03_resnet50_niters10_ila50_l3_1_alpha-1.0_augac --models *
```
The parameter for the mandatory field `-f` should be the exact folder name to test in `data/attack_batches/`.

To test the attack only on VGG19 and Inception V3, run
```
python test.py -f <foldername> --models vgg19/inception_v3
```
The model names are separated with slash `/`.


## Acknowledgements

The following resources are very helpful for our work:

Pretrained models on ImageNet:
- [Torchvision](https://pytorch.org/vision/stable/models.html)
- [PNASNet](https://github.com/Cadene/pretrained-models.pytorch)
- [SENet](https://github.com/moskomule/senet.pytorch)
