import numpy as np



def movieLensResidualComputation(M,X_true,MissingIndCoord,DistribProps,eps=1e-5,upper_lim=5,lower_lim=1):
    mu_O_list,std_O_list = DistribProps
    M_invnorm  = M * (np.array(std_O_list)+eps) + np.array(mu_O_list)
    X_true_invnorm  = X_true * (np.array(std_O_list)+eps) + np.array(mu_O_list)
    M_invnorm[M_invnorm>upper_lim]=upper_lim
    M_invnorm[M_invnorm<lower_lim]=lower_lim
    error_term = np.mean(np.abs(M_invnorm[MissingIndCoord[0],MissingIndCoord[1]]-X_true_invnorm[MissingIndCoord[0],MissingIndCoord[1]]))/(upper_lim-lower_lim)
    return error_term