function parse_command_line(; log = false)
    settings = ArgParseSettings(autofix_names = true)

    @add_arg_table settings begin
        "--experiment"
            arg_type = Symbol
            required = true
        "--experiment-version", "--version"
            arg_type = Int
            required = true
        "--stabilization-param", "--gamma"
            arg_type = Float64
        "--model-dir"
            arg_type = String
            default = "models"

        # Data generation args
        "--dt"
            arg_type = BigFloat
            required = true
        "--T"
            arg_type = BigFloat
            required = true
        "--transient-seconds", "--transient"
            arg_type = BigFloat
            default = zero(BigFloat)
        "--data-solver"
            arg_type = OrdinaryDiffEqAlgorithm
            default = Vern9()
        "--data-reltol"
            arg_type = BigFloat
            default = BigFloat(1e-24)
        "--data-abstol"
            arg_type = BigFloat
            default = BigFloat(1e-24)
        
        # Data split args
        "--steps"
            arg_type = Int
            required = true
        "--shuffle"
            action = :store_true
        # Single trajectory
        "--train-frac"
            arg_type = Float64
        "--valid-frac"
            arg_type = Float64
        # Multiple trajectories
        "--n-train"
            arg_type = Int
        "--n-valid"
            arg_type = Int
        "--n-test"
            arg_type = Int
    end

    common_settings = NeuralDiffEqTools.get_common_settings()
    import_settings!(settings, common_settings)

    args = parse_args(settings)

    if log
        NeuralDiffEqTools.log_args(args)
    end

    return args
end
