import NeuralDiffEqTools: multiple_shooting
function multiple_shooting(prob, time_series::NeuralDiffEqTools.TimeSeries; steps::Int, shuffle = false)
    (; times, trajectory) = time_series
    start_indexes = collect(1:steps:length(time_series)-steps)
    if shuffle
        shuffle!(start_indexes)
    end
    return [(prob, times[i:i+steps], trajectory[:, i:i+steps]) for i in start_indexes]
end
