import NeuralDiffEqTools: predict
function NeuralDiffEqTools.predict(
    model::Model;
    u0,
    saveat,
    solver = Tsit5(),
    reltol::T = 1.0f-6,
    abstol::T = 1.0f-6,
    maxiters = 1_000_000,
) where {T}
    tspan = (saveat[1], saveat[end])
    prob = remake(model.prob; u0, tspan)
    return NeuralDiffEqTools.predict(
        prob,
        model.θ;
        solver,
        saveat,
        reltol,
        abstol,
        maxiters,
    )
end
