import matplotlib.pyplot as plt
import seaborn as sns

sns.set_style("darkgrid")

# file1 = './logs/cifar100-c/FedEM/results-conceptem-3-1.0.txt'
# file2 = './logs/cifar100-c/FedEM/results-conceptem-adam-3-006.txt'

# file1 = './logs/cifar10-c-1/FedEM/results-conceptem-3-1.0.txt'
# file2 = './logs/cifar10-c-1/FedEM/results-conceptem-adam-3-006.txt'

file1 = './logs/cifar10-c/results-conceptEM_SW-030-adapt-split-no-initial.txt'
file2 = './logs/cifar10-c/results-conceptEM_SW-06-lr-test-for-3-loss-base-split.txt'

with open(file1, 'r') as f:
    lines1 = f.readlines()
    lines1 = [x.strip() for x in lines1]
    lines1 = [x.split(', ') for x in lines1]
    lines1 = [[float(y) for y in x] for x in lines1]

with open(file2, 'r') as f:
    lines2 = f.readlines()
    lines2 = [x.strip() for x in lines2]
    lines2 = [x.split(', ') for x in lines2]
    lines2 = [[float(y) for y in x] for x in lines2]


global_acces_1 = []
global_acces_2 = []

i = 0
for line in lines1:
    if i % 2 == 1:
        global_acces_1.append(float(line[3]))
    i += 1

i = 0
for line in lines2:
    if i % 2 == 1:
        global_acces_2.append(float(line[3]))
    i += 1

print(global_acces_1)
print(global_acces_2)

end = 190
x = [i for i in range(end)]

plt.plot(x, global_acces_1[:end], label='Adaptive FedIAS', color=sns.color_palette('deep')[0])
plt.plot(x, global_acces_2[:end], label='FedIAS', color=sns.color_palette('deep')[1])

plt.legend(loc=4)
plt.xlabel('Communication Rounds')
plt.ylabel('Accuracy')
# plt.title('CIFAR10 dataset')
plt.savefig('conceptem-adapt-cifar10-add.pdf')

