import re
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt

sns.set_style("darkgrid")
current_palette = sns.color_palette('RdBu')

nums = [2, 3, 4]


for n, num in enumerate(nums):

    file = './logs/cifar10-c/mean-I-conceptEM_SW-0-06-lr-test-for-{}-loss-base-split.txt'.format(num)

    with open(file, 'r') as f:
        lines = f.readlines()
        lines = [x.strip() for x in lines]
        lines = [x.split(', ') for x in lines]
        lines = [[re.search(r'[0-9\.]+', y).group() for y in x] for x in lines]
        lines = [[float(y) for y in x] for x in lines]

    lines = np.array(lines)
    means = np.mean(lines, axis=1)
    stds = np.std(lines, axis=1)
    stds_portion = np.array([s / m for s, m in zip(stds, means)])

    end = 80
    x = [i+1 for i in range(end)]

    # plt.plot(x, means[:end], label='mean', color = sns.color_palette('deep')[0])
    # plt.plot(x, stds[:end], label='standard deviation', color = sns.color_palette('deep')[1])
    plt.plot(x, stds_portion[:end], label='std / mean, K={}'.format(num), color = sns.color_palette('deep')[n])

plt.legend(loc=4)
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)
plt.xlabel('Communication Rounds', fontsize=18)
plt.ylabel('Metrics', fontsize=18)
# plt.title('Convergence of Adaptive process')
# plt.savefig('./plots/conceptem-sw-test-{}.pdf'.format(num))
plt.savefig('./plots/conceptem-sw-test-portion.pdf')