# Train CIFAR10 with PyTorch

## Training
```
# Start training with: 
CUDA_VISIBLE_DEVICES=0 python main.py

# Training with self-prepared CIFAR data (e.g. data processed by the pixel-level quantizer):
CUDA_VISIBLE_DEVICES=0 python main.py --data_dir [CIFAR10-DIR]

# Training with subset indices (Multiple subset files can be sepcified here):
CUDA_VISIBLE_DEVICES=0 python main.py --select_indices [INDICES_FILE1] [INDICES_FILE2] ...

# For data keep ratio higher than 10%, we use a batch size of 128. Otherwise, we use a batch size of 16 for sufficient training. 
# Training with different batch size:
CUDA_VISIBLE_DEVICES=0 python main.py --batch_size 16
```

## Template Commands

```
CUDA_VISIBLE_DEVICES=0 python main.py --data_dir ../dataset_quantization/pixel_quantized_cifar/ \
    --select_indices ../dataset_quantization/sample_quantized_cifar_010/select_indices_CIFAR10_0.1.npy --batch_size 16

CUDA_VISIBLE_DEVICES=0 python main.py --data_dir ../dataset_quantization/pixel_quantized_cifar/ \
    --select_indices ../dataset_quantization/sample_quantized_cifar_010/select_indices_CIFAR10_0.6.npy
```

