import operator as op
import numpy as np
from scipy import stats as st

def mode_over_array(arr):
    return st.mode(arr, keepdims=True)[0][0]
def std_func(arr):
    return np.std(arr, ddof=0)


LANG_SYNTAX = {
    "time_range":{"time_min":[], "time_max":[]},
    "agg_op_time_num":{np.mean:[], np.max:[], np.min:[], std_func:[]},
    "agg_op_str_time_num":{"mean":[], "max":[], "min":[], "std":[]},
    "agg_op_time_cat":{mode_over_array:[]},
    "agg_op_str_time_cat":{"mode":[]},
    "formula":{"num_comp":["num_feat", "num_op"]},
    "num_feat":{}, #dynamically populated
    "cat_feat":{},
    # comment this line, pick an interval
    "cat_op":{op.__eq__:[]},
    "num_op":{op.__le__:[], op.__ge__:[]},
    #feature aggregated value syntax dynamically added
}

CAT_FEATS = ["SEX_C.x", "ETHNIC_GROUP", "FEVER 100.5 OR GREATER","GLOBAL02", "STAGE_GROUP", "RACE", "RASH YES/NO", "DECREASED APPETITE SEVERITY", "MARITAL_STATUS", "PRO QUESTIONNAIRE SYMPTOMS TO ADDRESS"]
OTHER_SCORE_FEATS = ["SADNESS INTERFERENCE SCORE", "DIARRHEA FREQUENCY SCORE", "ACTIVITIES & FUNCTION SCORING QUESTION", "CONSTIPATION SEVERITY SCORE", "NAUSEA FREQUENCY SCORE", "FATIGUE INTERFERENCE SCORE", "SHORTNESS OF BREATH INTERFERENCE SCORE", "GLOBAL02 SCORING QUESTION","CONSTIPATION  SCORE", "PAT_AGE", "NUMBNESS & TINGLING  SCORE","ANXIETY INTERFERENCE SCORE", "DECREASED APPETITE SEVERITY SCORE", "DECREASED APPETITE  SCORE"]
DROP_FEATS = sorted(["ANXIETY INTERFERENCE","NUMBNESS & TINGLING SEVERITY", "ACTIVITIES & FUNCTION", "SADNESS INTERFERENCE", "DIARRHEA FREQUENCY", "CONSTIPATION SEVERITY", "NAUSEA FREQUENCY", "FATIGUE INTERFERENCE", "SHORTNESS OF BREATH INTERFERENCE", "CONSTIPATION ", "NUMBNESS & TINGLING ","DECREASED APPETITE ", "ECOG_strict","ZIP", "Unnamed: 0", "Unnamed: 0.1", "SubjectId", "EpicPatientId", "Empi", "HupMrn", "TreatmentPlanId", "ProtocolId", "ProtocolName", "Regimen", "other", "fin_class_name", "EMPI", "NPI", "DEPARTMENT_NAME", "CSN", "PROVIDER_PENN_ID", "Pred", "PROVIDER_NAME", "count", "batch_id", "X_id", "BIRTH_DATE", "SDE_VALUE", "SEX_C.y", "SEX_C_x", "X"])
UNKNOWN=["PROV_TYPE", "SPECIALTY", "TreatedCycles"]
DATE_FEATS=["subtype","SEX_C_y","APPT_DATE","DATE_DIFF_DAYS","CODE_TIME_DATE","FirstTreatmentDate", "LastTreatmentDate", "stage_date", "contact_date", "date", "pred_date", "APPT_TIME", "appt_date", "DEATH_DATE", "EDIT_DATETIME"]
OTHER_FEATS={"PAT_ID", "line"}
Prob_FEATS={"NUMBNESS & TINGLING SEVERITY SCORE"}

# DROP_FEATS = sorted(["PAT_ID", 'label', "Pred", "PROVIDER_PENN_ID"])

NON_STR_REP= {
    op.__le__:"<=",
    op.__ge__:">=",
    op.__eq__:"=="
}