# Memory-efficient Reinforcement Learning with Knowledge Consolidation

This repository is the official implementation of *Memory-efficient Reinforcement Learning with Knowledge Consolidation*. 


## Requirements

- Python (>=3.6)
- [PyTorch](https://pytorch.org/)
- [Gym && Gym Games](https://github.com/qlan3/gym-games): You may only install part of Gym (`classic_control, box2d`) with `pip install 'gym[classic_control, box2d]'`.
- Others: Please check `requirements.txt`; install with  `pip install -r requirements.txt`.


## Experiments

### Training

All hyperparameters including parameters for grid search are stored in a configuration file in directory `configs`. To run an experiment, a configuration index is first used to generate a configuration dict corresponding to this specific configuration index. Then we run an experiment defined by this configuration dict. All results including log files are saved in directory `logs`. Please refer to the code for details.

For example, run the experiment with configuration file `catcher_dqn.json` and configuration index `1`:

```python main.py --config_file ./configs/catcher_dqn.json --config_idx 1```


### Grid Search (Optional)

First, we calculate the number of total combinations in a configuration file (e.g. `catcher_dqn.json`):

`python utils/sweeper.py`

The output will be:

`Number of total combinations in catcher_dqn.json: 10`

Then we run through all configuration indexes from `1` to `10`. A simple way is using a bash script:

``` bash
for index in {1..10}
do
  python main.py --config_file ./configs/catcher_dqn.json --config_idx $index
done
```

[Parallel](https://www.gnu.org/software/parallel/) is usually a better choice to schedule a large number of jobs:

``` bash
parallel --eta --ungroup python main.py --config_file ./configs/catcher_dqn.json --config_idx {1} ::: $(seq 1 10)
```

Any configuration index that has the same remainder (divided by the number of total combinations) should has the same configuration dict (except random seeds). So for multiple runs, we just need to add the number of total combinations to the configuration index. For example, do 5 runs for configuration index `1`:

```
for index in 1 11 21 31 41
do
  python main.py --config_file ./configs/catcher_dqn.json --config_idx $index
done
```

Or a simpler way:
```
parallel --eta --ungroup python main.py --config_file ./configs/catcher_dqn.json --config_idx {1} ::: $(seq 1 10 50)
```


### Analysis (Optional)

To analyze the experimental results, just run:

`python analysis.py`

Inside `analysis.py`, `unfinished_index` will print out the configuration indexes of unfinished jobs based on the existence of the result file. `memory_info` will print out the memory usage information and generate a histogram to show the distribution of memory usages in directory `logs/catcher_dqn/0`. Similarly, `time_info` will print out the time information and generate a histogram to show the distribution of time in directory `logs/catcher_dqn/0`. Finally, `analyze` will generate `csv` files that store training and test results. More functions are available in `utils/plotter.py`.

Enjoy!