# GenerationPrograms: Fine-grained Attribution with Executable Programs


We provide the code to run ALCE baseline and our GenerationPrograms.

We describe each file:

1. `program.py`: File that contains the object Program that construct the tree, keeps record of the modules input and output etc.
2. `run.py`: Code to run the baseline ALCE method.
3. `run_program.py`: Code to run GeneartionPrograms.
4. `util.py`: utilities for parsing and splitting sentences.

For the code it assumes a model object that creates `Model()` object and running `run(prompt)` method should take care of running the model.

Both code takes the same arguments, an example to run the code:
```bash
dataset="lfqa"
python src/run.py --data data/${dataset}.json --model gpt4o \
    --prompt prompts/${dataset}_fewshot.txt --fewshot_examples prompts/${dataset}_fewshots_doc.json \
    --output output/gpt4o_${dataset}_alce.json

python src/run_program.py --model gpt4o --add_citation \
    --data data/${dataset}.json  \
    --prompt prompts/program_fewshot.txt  --fewshot_examples prompts/${dataset}_fewshots_program.json \
    --output output/gpt4o_${dataset}_program.json
```