# On Logical Extrapolation for Mazes with Recurrent and Implicit Networks

## Python and Dependencies

To ensure compatibility with the project, please use **Python 3.10.14**. You can create a virtual environment and install the required dependencies by running the following commands:

```bash
# Create and activate a virtual environment (optional but recommended)
python3.10 -m venv venv
source venv/bin/activate  # On macOS/Linux
venv\Scripts\activate     # On Windows
```

## Install the dependencies
```bash
pip install -r requirements.txt
```

## Models
The models are:
- `dt_net`: model trained by Bansal et. al. with architecture `dt_net_2d.py`
- `pi_net_1`: model trained by Anil et. al. with architecture `deq_v3.py` and weights `training-brumous-Francina` from `output_deq_mazes`


## Model Weights

The pre-trained weights for `dt_net` can be downloaded from [Deep Thinking Systems](https://drive.google.com/drive/folders/1QzLt_9n2sNYrH7r8an0WMh4LnsKyzY7h). Once downloaded, ensure to place the weight .pth files into DeepThinkingV2/models.
The pre-trained weights for `pi_net_1` are not yet publicly available. 