clear
close all;

%% Variable & Workspace settings
SIM = true; % use simulated data or real-world data.
VARIDX = 7; % 3 (vx), 4 (vy), 7 (omega)
if SIM
    % Loading sim Data into the MATLAB Workspace
    load gpk_Autoverse_TMS_04_11B.mat
    load gpk_Autoverse_TMS_04_10.mat
    load AutoverseTMS0411B.mat
    load AutoverseTMS0410.mat
    data_tt = AutoverseTMS0410;
    data_tr = AutoverseTMS0411B;
    gp_tt_states = states_0410;
    gp_tt_inputs = inputs_0410;
    gp_tr_states = states_0411B;
    gp_tr_inputs = inputs_0411B;
else
    % Loading real-world Data into the MATLAB Workspace
    load gpk_LVMS_23_01_04_B.mat
    load gpk_LVMS_23_01_04_C.mat
    load LVMS230104B.mat
    load LVMS230104C.mat
    data_tt = LVMS230104B;
    data_tr = LVMS230104C;
    gp_tt_states = states_0104B;
    gp_tt_inputs = inputs_0104B;
    gp_tr_states = states_0104C;
    gp_tr_inputs = inputs_0104C;
end
%% Importing dataset
% Testing set
RC_states_tt = data_tt(1:end,2:8);
len_states_t = size(RC_states_tt, 1);
RC_inputs_tt = zeros(len_states_t, 3);
RC_inputs_tt(:,1) = data_tt(1:end,9);
RC_inputs_tt(:,2) = data_tt(1:end,16);
RC_inputs_tt(:,3) = data_tt(1:end,end);
GP_states_tt = gp_tt_states;
GP_inputs_tt = gp_tt_inputs;
% Training set
RC_states_tr = data_tr(1:end,2:8);
len_states_r = size(RC_states_tr, 1);
RC_inputs_tr = zeros(len_states_r, 3);
RC_inputs_tr(:,1) = data_tr(1:end,9);
RC_inputs_tr(:,2) = data_tr(1:end,16);
RC_inputs_tr(:,3) = data_tr(1:end,end);
GP_states_tr = gp_tr_states;
GP_inputs_tr = gp_tr_inputs;

%% Initializing dataset for modeling training

y_all_tr = RC_states_tr(1:len_states_r-1, :) - GP_states_tr(2:end, :);
X_tr = zeros(len_states_r-1, 8);
X_tr(:,1:5) = GP_states_tr(1:end-1,3:end);
% X_tr(:,3:4) = GP_states_tr(1:end-1,6:7);
X_tr(:,6:end) = GP_inputs_tr(1:end-1, :);
Y_tr = y_all_tr(:,VARIDX);
% Testing data
y_all_tt = RC_states_tt(1:len_states_t-1, :) - GP_states_tt(2:end, :);
X_tt = zeros(len_states_t-1, 8);
X_tt(:,1:5) = GP_states_tt(1:end-1,3:end);
% X_tt(:,3:4) = GP_states_tt(1:end-1,6:7);
X_tt(:,6:end) = GP_inputs_tt(1:end-1, :);
Y_tt = y_all_tt(:,VARIDX);

%% Using Objects to Represent Data for System Identification
% Creating iddata Objects
if ~SIM 
    endidx = len_states_t - 520;
    startidx = 1; %1000;
    Y_tr = Y_tr(startidx:end);
    X_tr = X_tr(startidx:end,:);
    Y_tt = Y_tt(1:endidx);
    X_tt = X_tt(1:endidx,:);   
end

% Apply Savitzky-Golay filter
windowSize = 21;
polyOrder = 2;
X_tr_sm = sgolayfilt(X_tr, polyOrder, windowSize);
Y_tr_sm = sgolayfilt(Y_tr, polyOrder, windowSize);
X_tt_sm = sgolayfilt(X_tt, polyOrder, windowSize);
Y_tt_sm = sgolayfilt(Y_tt, polyOrder, windowSize);
Ts = 0.04; % Sample time is 0.04 sec
train_data = iddata(Y_tr_sm, X_tr_sm, Ts);
test_data = iddata(Y_tt_sm, X_tt_sm, Ts);
% test_data.OutputName = {'Error Omega'};

%% Estimating State-space Model 
opt = ssestOptions;
opt.InitializeMethod = 'n4sid';
opt.InitialState = 'estimate'; %'backcast';'estimate'
opt.N4Weight = 'CVA'; %'SSARX';'MOESP'
opt.Focus = 'simulation'; %'simulation','prediction';
opt.EnforceStability = true;
opt.SearchMethod = 'lm'; % or 'lsqnonlin' 'lm'
% nx = 1:12;
% mn4sid = n4sid(train_data, nx);
[mn4sid, x0] = n4sid(train_data, 8, opt);
Np = 5;
compare(test_data,mn4sid);
[y,fit,ic] = compare(test_data,mn4sid);

%% Evaluation metrics
error = y.y - Y_tt;
perf_MAE = mae(error);
perf_RMSE = sqrt(mean(error.^2));
perf_NRMSE = perf_RMSE / (max(Y_tt)-min(Y_tt));
Eval = ["Mean Absolute Error: ", perf_MAE];
Eval2 = ["Root Mean Squared Error: ", perf_RMSE];
Eval3 = ["Normalized Root Mean Squared Error: ", perf_NRMSE];
RSS = sum((y.y-Y_tt).^2);
TSS = sum((Y_tt - mean(Y_tt)).^2);
R2  = 1 - RSS/TSS;
Eval4 = ["R Squared: ", R2];
disp(Eval)
disp(Eval2)
disp(Eval3)
disp(Eval4)
    

%% State space matrices
A = mn4sid.A;
B = mn4sid.B;
C = mn4sid.C;



