class Config():
    
    def __init__(self,
                 pipelineDir,
                 trainingDataFile,      
                 validationDataFile,
                 testDataFile,
                 partitioningFile,
                 partitioningSettingFile,
                 dataSeparationKnownBounds,
                 dataSeparationType,
                 totalSamples,
                 sampleSplit,
                 epochs,
                 sweeps):   

        self.attributes = {'input': {'dir':                       pipelineDir,
                                     'trainingDataFile':          trainingDataFile,
                                     'validationDataFile':        validationDataFile,
                                     'testDataFile':              testDataFile,
                                     'partitioningFile':          partitioningFile,
                                     'partitioningSettingFile':   partitioningSettingFile,
                                     'dataSeparationKnownBounds': dataSeparationKnownBounds,
                                     'xDimensions':               None,
                                     'yDimensions':               None},
                           'test': {'dataSeparationType':     dataSeparationType,
                                    'totalSamples':           totalSamples,
                                    'sampleSplit':            sampleSplit,
                                    'layersBounds':           None,
                                    'neuronsPerLayerBounds':  None,
                                    'learningRateBounds':     None,
                                    'epochs':                 epochs,
                                    'sweeps':                 sweeps,
                                    'batchSize':              None,
                                    'featureRangeX':          None,
                                    'featureRangeY':          None},
                           'output': {'dir': pipelineDir}}
