import os


class ConfigReader():

    def __init__(self, inputDir):
        self._inputDir = inputDir


    def readConfig(self, config):
        configFileName = self._inputDir + 'configPartitioning.txt'
        
        if not os.path.isfile(configFileName):
            raise IOError('No config file found!')
        
        config.attributes['test']['layersBounds']          = self.readLayersBounds         (configFileName)
        config.attributes['test']['neuronsPerLayerBounds'] = self.readNeuronsPerLayerBounds(configFileName)
        config.attributes['test']['learningRateBounds']    = self.readLearningRateBounds   (configFileName)
        config.attributes['test']['batchSize']             = self.readBatchSize            (configFileName)
        config.attributes['test']['featureRangeX']         = self.readFeatureRangeX        (configFileName)
        config.attributes['test']['featureRangeY']         = self.readFeatureRangeY        (configFileName)


    def readLayersBounds(self, configFileName):
        with open(configFileName) as configFile:
            for line in configFile.read().split('\n'):
                if 'layersBounds' in line:
                    return [int(bound) for bound in line.split('[')[2].split(']')[0].split(',')]


    def readNeuronsPerLayerBounds(self, configFileName):
        with open(configFileName) as configFile:
            for line in configFile.read().split('\n'):
                if 'neuronsPerLayerBounds' in line:
                    return [int(bound) for bound in line.split('[')[2].split(']')[0].split(',')]
                

    def readLearningRateBounds(self, configFileName):
        with open(configFileName) as configFile:
            for line in configFile.read().split('\n'):
                if 'learningRateBounds' in line:
                    return [float(bound) for bound in line.split('[')[2].split(']')[0].split(',')]


    def readBatchSize(self, configFileName):
        with open(configFileName) as configFile:
            for line in configFile.read().split('\n'):
                if 'batchSize' in line:
                    return int(line.split(':')[1])


    def readFeatureRangeX(self, configFileName):
        return self.readFeatureRange(configFileName, 'X')

    def readFeatureRangeY(self, configFileName):
        return self.readFeatureRange(configFileName, 'Y')

    def readFeatureRange(self, configFileName, xy):
        with open(configFileName) as configFile:
            for line in configFile.read().split('\n'):
                if 'featureRange' + xy in line:
                    return tuple([float(bound) for bound in line.split(']')[1].split('(')[1].split(')')[0].split(',')])
