import os


class DirFinder():

    def __init__(self, config):
        self.findDir(config)

    def findDir(self, config):
        dirs = [ f.path for f in os.scandir(config.attributes['input']['dir']) if f.is_dir() ]
        dirs.sort()
        self._dir = dirs[-1] + '/'

    def getDir(self):
        return self._dir
    
    def checkForSVM(self, config):
        partitioningFilePath        = self._dir + config.attributes['input']['partitioningFile']
        partitioningSettingFilePath = self._dir + config.attributes['input']['partitioningSettingFile']

        partitioningAvailable        = os.path.isfile(partitioningFilePath)
        partitioningSettingAvailable = os.path.isfile(partitioningSettingFilePath)

        if not partitioningAvailable or not partitioningSettingAvailable:
            return False
        return True
