import NetworkStrategy.ParallelNetworks.AbstractDataSeparator as AbstractDataSeparator


class KnownBoundsDataSeparator(AbstractDataSeparator.AbstractDataSeparator):

    def __init__(self, config):
        self._config = config.attributes


    def separateData(self, data):
        separatedData = []

        for knownBound in self._config['input']['dataSeparationKnownBounds']:
            leftBoundIndices  = data[:,0] >= knownBound[0]
            rightBoundIndices = data[:,0] <  knownBound[1]
            separationIndices = [all(combinedIndex) for combinedIndex in zip(leftBoundIndices, rightBoundIndices)]
            separatedData.append(data[:,][separationIndices])

        return separatedData
