import matplotlib.pyplot


class Plotter():

    def __init__(self, config, outputDir):
        self._config = config.attributes
        self._outputDir = outputDir


    def plotSamples(self, samplesX, samplesY, title, name):
        if self._config['input']['xDimensions'] == 1 and self._config['input']['yDimensions'] == 1:
            self.plotSamples2d(samplesX, samplesY, title, name)
        else:
            return


    def plotSamples2d(self, samplesX, samplesY, title, name):
        matplotlib.pyplot.figure()
        matplotlib.pyplot.scatter(samplesX, samplesY, label='Test samples')
        matplotlib.pyplot.title('Samples of ' + title)
        matplotlib.pyplot.legend()
        matplotlib.pyplot.savefig(self._outputDir + name + 'Samples.png')
        matplotlib.pyplot.close()


    def plotPrediction(self, samplesX, samplesY, predictionY, title, name):
        if self._config['input']['xDimensions'] == 1 and self._config['input']['yDimensions'] == 1:
            self.plotPrediction2d(samplesX, samplesY, predictionY, title, name)
        else:
            return


    def plotPrediction2d(self, samplesX, samplesY, predictionY, title, name):
        matplotlib.pyplot.figure()
        matplotlib.pyplot.scatter(samplesX, samplesY, label='Test samples')
        matplotlib.pyplot.scatter(samplesX, predictionY, label='Prediction')
        matplotlib.pyplot.title('Prediction for ' + title + ' after ' + str(self._config['test']['epochs']) + ' epochs')
        matplotlib.pyplot.legend()
        matplotlib.pyplot.savefig(self._outputDir + name + 'Prediction.png')
        matplotlib.pyplot.close()
