import numpy


class SavingEngine():
    
    def __init__(self, outputDir):
        self._outputDir = outputDir


    def saveLosses(self, losses, lossTitles):
        fileName = 'losses.txt'
        with open(self._outputDir + fileName, 'w+') as lossFile:
            lossFile.write('Losses: \n')
            for loss, lossTitle in zip(losses, lossTitles):
                lossFile.write(lossTitle + ' loss: ' + str(loss) + '\n')
          

    def saveImprovement(self, oneNetworkQuality, parallelNetworkImprovement): # todo: erweitern
        fileName = str(oneNetworkQuality).split('.')[1] + '_improvement.txt'
        with open(self._outputDir + fileName, 'a+') as improvementFile:
            improvementFile.write(str(parallelNetworkImprovement).split('.')[1] + '\n')


    def saveConfig(self, config):
        keys = self.defineConfigKeys()
        fileName = self._outputDir + 'config_parallelNetworks.txt'
        with open(fileName, mode='w+') as configFile:
            for multiLevelKey in keys:
                val = config.attributes
                for nextLevelKey in multiLevelKey:
                    val = val[nextLevelKey]
                configFile.write(str(multiLevelKey) + ': ' + str(val) + '\n')
                

    def saveHyperparameters(self, learningRates, layers, neurons, parameters, oneAllowedParams):
        fileName = self._outputDir + 'hyperparameters.txt'
        with open(fileName, 'w+') as hyperparametersFile:
            for label, (learningRate, layer, neuron, parameter) in enumerate(zip(learningRates, layers, neurons, parameters)):
                if label == 0:
                    hyperparametersFile.write('Hyperparameters of single model:\n')
                    hyperparametersFile.write(f'Learning Rate: {str(learningRate)}\nLayers: {str(layer)}\nNeurons: {str(neuron)}\nParameters: {parameter}\nAllowed Parameters: {oneAllowedParams}\n\n')
                else:
                    hyperparametersFile.write(f'Hyperparameters of expert {str(label)}:\n')
                    hyperparametersFile.write(f'Learning Rate: {str(learningRate)}\nLayers: {str(layer)}\nNeurons: {str(neuron)}\nParameters: {parameter}\n\n')


    def saveWeights(self, weights):
        for label, weight in enumerate(weights):
            if label == 0:
                fileName = self._outputDir + 'weights_singleModel.csv'
            else:
                fileName = self._outputDir + 'weights_expert' + str(label) + '.csv'
            numpy.savetxt(fileName, weight, delimiter=",")


    def defineConfigKeys(self):
        return [['input', 'dir'],
                ['input', 'trainingDataFile'],
                ['input', 'validationDataFile'],
                ['input', 'testDataFile'],
                ['input', 'partitioningFile'],
                ['input', 'partitioningSettingFile'],
                ['input', 'dataSeparationKnownBounds'],
                ['input', 'xDimensions'],
                ['input', 'yDimensions'],
                ['test', 'dataSeparationType'],
                ['test', 'totalSamples'],
                ['test', 'sampleSplit'],
                ['test', 'layersBounds'],
                ['test', 'neuronsPerLayerBounds'],
                ['test', 'learningRateBounds'],
                ['test', 'epochs'],
                ['test', 'sweeps'],
                ['test', 'batchSize'],
                ['test', 'featureRangeX'],
                ['test', 'featureRangeY'],
                ['output', 'dir']]
