import sklearn.preprocessing


class ScalingEngine():

    def __init__(self, featureRange):
        self._scaler = sklearn.preprocessing.MinMaxScaler(feature_range=featureRange)


    def fitAndScale(self, unscaledSamples):
        self.fit(unscaledSamples)
        return self.scale(unscaledSamples)


    def fit(self, unscaledSamples):
        self._scaler = self._scaler.fit(unscaledSamples)


    def scale(self, unscaledSamples):
        if unscaledSamples.size == 0:
            return unscaledSamples
        return self._scaler.transform(unscaledSamples)


    def unscale(self, scaledSamples):
        if scaledSamples.size == 0:
            return scaledSamples
        return self._scaler.inverse_transform(scaledSamples)
