﻿
class Config():
    def __init__(self,
                 inputDir,
                 outputDir,
                 inputSamplesFile,
                 samples,
                 layersBounds,
                 neuronsPerLayerBounds,
                 learningRateBounds,
                 batchSize,
                 epochs,
                 initialNumOfNets,
                 featureRangeX,
                 featureRangeY,
                 startDroppingAdding,
                 droppingActive,
                 droppingInterv,
                 droppingReplacability,
                 addingActive,
                 addingInterv,
                 addingCatchUpTrainingPatience,
                 addingImprovement):   

        self.attributes = {'input': {'dir':         inputDir,
                                     'samplesFile': inputSamplesFile,
                                     'xDimensions': None,
                                     'yDimensions': None},
                           'network': {'layersBounds':          layersBounds,
                                       'neuronsPerLayerBounds': neuronsPerLayerBounds,
                                       'learningRateBounds':    learningRateBounds},
                           'test': {'samples':                       samples,
                                    'epochs':                        epochs,
                                    'batchSize':                     batchSize,
                                    'initialNumOfNets':              initialNumOfNets,
                                    'featureRangeX':                 featureRangeX,
                                    'featureRangeY':                 featureRangeY,
                                    'startDroppingAdding':           startDroppingAdding,
                                    'droppingActive':                droppingActive,
                                    'droppingInterv':                droppingInterv,
                                    'droppingReplacability':         droppingReplacability,
                                    'addingActive':                  addingActive,
                                    'addingInterv':                  addingInterv,
                                    'addingCatchUpTrainingPatience': addingCatchUpTrainingPatience,
                                    'addingImprovement':             addingImprovement},
                           'output': {'dir': outputDir}}
