﻿import csv
import numpy
import sklearn.model_selection


class DataLoader():
    def __init__(self, config):
        self._config = config

        self.readDimensions()
        self.loadData()
        self.chooseData()
        self.divideBetwTestTrainData()


    def readDimensions(self):
        with open(self._config['input']['dir'] + self._config['input']['samplesFile']) as inputFile:
            firstLine = next(csv.reader(inputFile))
            self._config['input']['xDimensions'] = int(firstLine[0].split('=')[1])
            self._config['input']['yDimensions'] = int(firstLine[1].split('=')[1])
            

    def loadData(self):
        self._data = numpy.loadtxt(fname = self._config['input']['dir'] + self._config['input']['samplesFile'], delimiter=',', skiprows=1)


    def chooseData(self):
        self._data = self._data[numpy.random.choice(a=self._data.shape[0], size=self._config['test']['samples'], replace=False)]


    def divideBetwTestTrainData(self):
        self._trainingData = self._data
        self._testData     = numpy.zeros((0, self._config['input']['xDimensions'] + self._config['input']['yDimensions']))
        #self._trainingData, self._testData = sklearn.model_selection.train_test_split(self._data, test_size=0.1, shuffle=True)


    def getData(self):
        return self._trainingData, self._testData
        