﻿import sklearn


class ScalingEngine():

    def __init__(self, featureRange):
        self._scaler = sklearn.preprocessing.MinMaxScaler(feature_range=featureRange)


    def FitAndScale(self, unscaledSamples):
        self.Fit(unscaledSamples)
        return self.Scale(unscaledSamples)


    def Fit(self, unscaledSamples):
        self._scaler = self._scaler.fit(unscaledSamples)


    def Scale(self, unscaledSamples):
        return self._scaler.transform(unscaledSamples)


    def Unscale(self, scaledSamples):
        return self._scaler.inverse_transform(scaledSamples)
