﻿import numpy


class Evaluation():

    def __init__(self):
        self._numOfNets = numpy.zeros(0)
        self._droppingStats = []
        self._addingStats   = []


    def submitActiveNetIds(self, activeNetIds):
        self._numOfNets = numpy.append(self._numOfNets, len(activeNetIds))

    def submitDroppingStats(self, droppingStats):
        self._droppingStats.append(droppingStats)

    def submitAddingStats(self, addingStats):
        self._addingStats.append(addingStats)


    def getNumOfNets(self):
        return self._numOfNets

    def getDroppingAddingEpochs(self):
        droppingOneBasedEpochs = numpy.zeros(0)
        addingOneBasedEpochs   = numpy.zeros(0)

        for zeroBasedEpoch, droppingStats in enumerate(self._droppingStats):
            if droppingStats['active']:
                for _ in range(droppingStats['droppedNets']):
                    droppingOneBasedEpochs = numpy.append(droppingOneBasedEpochs, zeroBasedEpoch+1)

        for zeroBasedEpoch, addingStats in enumerate(self._addingStats):
            if addingStats['active']:
                if addingStats['addedNet'] == True:
                    addingOneBasedEpochs = numpy.append(addingOneBasedEpochs, zeroBasedEpoch+1)

        return droppingOneBasedEpochs, addingOneBasedEpochs

    
    def getDroppingReplacabilities(self):
        replacabilities = numpy.zeros((0,2))
        
        for zeroBasedEpoch, droppingStats in enumerate(self._droppingStats):
            if droppingStats['active']:
                for replacability in droppingStats['replacabilities']:
                    replacabilities = numpy.concatenate((replacabilities, numpy.array([[zeroBasedEpoch+1, replacability]])))
                    
        return replacabilities


    def getAddingImprovements(self):
        improvements = numpy.zeros((0,2))

        for zeroBasedEpoch, addingStats in enumerate(self._addingStats):
            if addingStats['active']:
                improvements = numpy.concatenate((improvements, numpy.array([[zeroBasedEpoch+1, addingStats['improvement']]])))

        return improvements


    def getTrainingEpochsAdding(self):

        absoluteTrainingEpochs = numpy.zeros((0,2))
        relativeTrainingEpochs = numpy.zeros((0,2))

        for zeroBasedEpoch, addingStats in enumerate(self._addingStats):
            if addingStats['active']:
                absoluteTrainingEpochs = numpy.concatenate((absoluteTrainingEpochs, numpy.array([[zeroBasedEpoch+1,  addingStats['trainedEpochs']                     ]])))
                relativeTrainingEpochs = numpy.concatenate((relativeTrainingEpochs, numpy.array([[zeroBasedEpoch+1,  addingStats['trainedEpochs'] / (zeroBasedEpoch+1)]])))

        return absoluteTrainingEpochs, relativeTrainingEpochs
