﻿import os
import datetime


class OutputDirCreator():

    def __init__(self, config):
        self._config = config.attributes
        self.createOutputDirs()


    def createOutputDirs(self):
        self._generalOutputDir = os.getcwd() + '/' + self._config['output']['dir'] + datetime.datetime.now().strftime('%Y_%m_%d_%H_%M_%S') + '/'
        self._mappingOutputDir = self._generalOutputDir + 'mapping/'
        os.makedirs(self._generalOutputDir)
        os.makedirs(self._mappingOutputDir)


    def getGeneralOutputDir(self):
        return self._generalOutputDir

    def getMappingOutputDir(self):
        return self._mappingOutputDir
