﻿import numpy


class EarlyStopper():

    def __init__(self, patience=1):
        self._patience = patience
        self._counter = 0
        self._minValLoss = numpy.inf


    def overfittingReached(self, valLoss):
        if valLoss < self._minValLoss:
            self._minValLoss = valLoss
            self._counter = 0
            return False
        else:
            self._counter += 1
            if self._counter >= self._patience:
                return True
            else:
                return False
