

from src.logger.wandb_logger import WandbLogger
from src.logger.mlflow_logger import MlflowLogger
from src.logger.base_logger import Logger
from dataclasses import dataclass
from enum import Enum


class LoggerType(Enum):
    NONE = Logger
    WANDB = WandbLogger
    MLFLOW = MlflowLogger


@dataclass
class LoggerConfig:
    project: str = "sentinel"
    group: str = "sentinel"
    name: str = "sentinel"


def get_logger(logger_type: LoggerType, config: LoggerConfig):
    if logger_type == LoggerType.WANDB:
        return WandbLogger(config)
    elif logger_type == LoggerType.MLFLOW:
        return MlflowLogger(config)
    else:
        return Logger()
