import uuid
from dataclasses import asdict

from src.logger.base_logger import Logger
import mlflow


class MlflowLogger(Logger):
    def __init__(self, config):
        super().__init__()
        self.config = config
        mlflow.set_experiment(config.project)

    def log_metrics(self, metrics: dict, step=None):
        mlflow.log_metrics(metrics, step=step)

    def log_metric(self, metric_name: str, metric_value, step=None):
        mlflow.log_metric(metric_name, metric_value, step=step)

    def log_params(self, params):
        pass

    def log_artifact(self, path):
        pass