import uuid
from dataclasses import asdict

from src.logger.base_logger import Logger
import wandb




class WandbLogger(Logger):
    def __init__(self, config):
        super().__init__()
        self.config = config
        dict_config = asdict(config)
        wandb.init(
            config=dict_config,
            project=dict_config['project'],
            group=dict_config['group'],
            name=dict_config['name'],
            id=str(uuid.uuid4()),
        )
        wandb.run.save()

    def log_metric(self, metric_name: str, metric_value, step=None):
        wandb.log(
            {metric_name: metric_value},
            step=step,
        )

    def log_metrics(self, metrics: dict, step):
        wandb.log(
            metrics,
            step=step,
        )


    def log_params(self, params):
        pass

    def log_artifact(self, path):
        pass