from dataclasses import dataclass

import torch


@dataclass
class Config:
    block_size: int = 128
    feature_size: int = 1
    n_layers: int = 2
    n_heads: int = 2
    d_model: int = 128
    dropout: float = 0.2
    bias: bool = False
    device: str = 'cpu'
    is_causal: bool = False
    return_attention: bool = False
    input_type: str = 'numeric'
    has_encoder: bool = True

    def __post_init__(self):
        if torch.cuda.is_available():
            self.device = 'cuda'
        else:
            self.device = 'cpu'


