import os
import sys
import pandas as pd
import numpy as np
import argparse
import json
import matplotlib.pyplot as plt
import subprocess
import shutil
# def args():
#     parser = argparse.ArgumentParser()
#     parser.add_argument('--domain_file', type=str, default='/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/pddl-instances/ipc-2014/domains/barman-sequential-agile/domain.pddl', help='Path to input directory')
#     parser.add_argument('--prob_file', type=str, default='/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/pddl-instances/ipc-2014/domains/barman-sequential-agile/instances/instance-1.pddl')
#     parser.add_argument('--output_file', type=str, default='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Val/output.sas')
#     return parser.parse_args()

def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, default='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/gpt4o_ipc.json')
    parser.add_argument('--output_dir', type=str, default='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/fast_download/')
    args = parser.parse_args()
    return args

class FastDownward:
    def __init__(self, args):
          self.input_file = args.input_file
          with open(self.input_file, 'r') as f:
               self.data = f.readlines()
          self.output_dir = args.output_dir
          self.task_list = ['/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/pddl-instances/ipc-2014/domains/barman-sequential-agile/instances/instance-1.pddl', 
                            'task_2', 
                            'task_3', 
                            'task_4', 
                            'task_5']
        
    def preprocess_pddl(self, pddl_str: str) -> str:
        # extract the content of pddl by regex
        patterns = [
            r'```pddl\n(.*?)\n```',
            r'```lisp\n(.*?)\n```'
        ]
        for pattern in patterns:
            match = re.search(pattern, pddl_str, re.DOTALL)
            if match:
                return match.group(1)

        return pddl_str
         
    
    def process_data(self):
          df_data = [i['doamin'] for i in self.data if i['file'] in self.task_list]
          data = []
          for item in df_data:
               data_pddl = self.preprocess_pddl(item)
               data.append(data_pddl)

               
           return data
        
      
    def run(self):
          data = self.process_data()
              

    
class process_pddl_file:
    def __init__(self,args):
        self.domain_file = args.domain_file
        self.prob_file = args.prob_file
        self.output_file = args.output_file
    def process_pddl_file(self):
        os.chdir('/lustre/fast/fast/txiao/zly/downward')
        subprocess.run(['./fast-downward.py', '--translate', self.domain_file], check=True)
        subprocess.run(['./fast-downward.py', '--alias', 'seq-sat-lama-2011', self.output_file], check=True)
        
        
  # 使用示例
if __name__ == "__main__":
    args = args()
    run = process_pddl_file(args)
    run.process_pddl_file()

    