Prompt_template = """
You are an expert at planning and writing pddl code. 

You would be given a natural language description of a planning problem, you are required to translate it to pddl code with both domain and problem code. 
Information about the AI agent will be provided in the domain description. Note that individual conditions in preconditions and effects should be listed separately. For example, “object_1 is washed and heated” should be considered as two separate conditions “object_1 is washed” and “object_1 is heated”. Also, in PDDL, two predicates cannot have the same name even if they have different parameters. Each predicate in PDDL must have a unique name, and its parameters must be explicitly defined in the predicate definition. It is recommended to define predicate names in an intuitive and readable way. Remember: Ignore the information that you think is not helpful for the planning task. 

The following is a template for your answer:
NL Description: the natural language description of a planning problem <nl_desc>
Problem: objects, initial state and goal specification <problem>
Domain: predicates and actions <domain>
Plan: According to the problem and domain file, you are required to esitimate the plan <plan>

Here is an example:
NL Description: 
You have 5 blocks. b2 is on top of b5.  b5 is on top of b1. b1 is on top of b4. b3 is on top of b2. b4 is on the table. b3 is clear. Your arm is empty. Your goal is to move the blocks. b4 should be on top of b3. <nl_desc>

Problem: 
(define (problem BW-rand-5)
(:domain blocksworld-4ops)
(:objects b1 b2 b3 b4 b5 )
(:init
(arm-empty)
(on b1 b4)
(on b2 b5)
(on b3 b2)
(on-table b4)
(on b5 b1)
(clear b3)
)
(:goal
(and
(on b4 b3))
)
)<problem>

Domain:
(define (domain blocksworld-4ops)
  (:requirements :strips)
(:predicates (clear ?x)
             (on-table ?x)
             (arm-empty)
             (holding ?x)
             (on ?x ?y))

(:action pickup
  :parameters (?ob)
  :precondition (and (clear ?ob) (on-table ?ob) (arm-empty))
  :effect (and (holding ?ob) (not (clear ?ob)) (not (on-table ?ob)) 
               (not (arm-empty))))

(:action putdown
  :parameters  (?ob)
  :precondition (holding ?ob)
  :effect (and (clear ?ob) (arm-empty) (on-table ?ob) 
               (not (holding ?ob))))

(:action stack
  :parameters  (?ob ?underob)
  :precondition (and (clear ?underob) (holding ?ob))
  :effect (and (arm-empty) (clear ?ob) (on ?ob ?underob)
               (not (clear ?underob)) (not (holding ?ob))))

(:action unstack
  :parameters  (?ob ?underob)
  :precondition (and (on ?ob ?underob) (clear ?ob) (arm-empty))
  :effect (and (holding ?ob) (clear ?underob)
               (not (on ?ob ?underob)) (not (clear ?ob)) (not (arm-empty))))) <domain>

Plan:
unstack b3 from b2,
putdown b3,
unstack b2 from b5,
putdown b2,
unstack b5 from b1,
putdown b5,
unstack b1 from b4,
putdown b1,
pickup b4,
stack b4 on b3 <plan>

Now its your turn to write the pddl code 
NL description is:
{NL Description}


"""

Domain_template = """
You will be given a natural language description of a planning problem. Your task is to translate this description into PDDL domain code. This includes defining predicates and actions based on the information provided.

Information about the AI agent will be provided in the natural language description. Note that individual conditions in preconditions and effects should be listed separately. For example, “object_1 is washed and heated” should be considered as two separate conditions “object_1 is washed” and “object_1 is heated”. Also, in PDDL, two predicates cannot have the same name even if they have different parameters. Each predicate in PDDL must have a unique name, and its parameters must be explicitly defined in the predicate definition. It is recommended to define predicate names in an intuitive and readable way. Remember: Ignore the information that you think is not helpful for the planning task.

You are only responsible for domain generation.
Before you generate the concrete domain code, you should first generate a natural language thought about the meaning of each variable, and the step-by-step explaination of the domain code.
Even if I didn't provide the exact name of the predicates and actions, you should generate them based on the information provided in the natural language description.

Template is:

### Thought:
predicates1: the name of predicate1, explanation of predictate1
...
predicaten: the name of predicaten, explanation of predictaten
action1: the name of action1, explanation of action1
...
actionn: the name of action, explanation of actionn
<thought>

### Domain:
```pddl
The concrete pddl code for domain.pddl 

Now its your time to generate the solution, you have to follow the format I provided above.
NL_Description:{NL_description}
"""

Problem_template = """
Prepare for generating a PDDL problem based on the provided natural language description of the specific planning problem. Follow the structure outlined below to ensure clarity and completeness.

1. Start with a brief overview of the situation described in the natural language. This should summarize the key entities, actions, goals, and any relevant initial conditions.

2. Identify all objects involved in the problem. List them clearly with a brief description for each to explain their roles.

3. Define the initial conditions clearly. Each initial condition should be listed separately, specifying the relevant predicates and any necessary arguments. 

4. Clearly state the goal or objectives of the problem using the appropriate predicates.

5. Write the PDDL code for the problem file. Ensure that it adheres to the PDDL syntax and structure, incorporating the previously identified objects, initial conditions, and goals.

Use the following template:

---

Thought:
### Objects

- **object_1**: Description of object 1
- **object_2**: Description of object 2
- **object_3**: Description of object 3
- ...

### Initial Conditions

- (predicate1 arguments) 
- (predicate2 arguments) 
- (predicate3 arguments) 
- ...

### Goal

To achieve the following objectives:
- (predicate arguments)
- (predicate arguments)
- ...

PDDL Problem Code:

```pddl
(define (problem problem_name)
(:domain domain_name)

(:objects
  object_1 object_2 object_3 - type
  ...
)

(:init
  ; Initial predicates describing the state of the world
  predicate1 arguments
  predicate2 arguments
  predicate3 arguments
  ...
)

(:goal
  (and
    ; Goal predicates
    predicate arguments
    predicate arguments
    ...
  )
)
)
```
NL_Description: {NL_Description}
"""

Domain2NL_template = """
Your task is to translate the given pddl domain to its corresponding natural language description. You will be provided with the pddl domain code, and you need to generate a natural language description that captures the essence of the domain.

Here are some examples of how to translate pddl domain code to natural language:
Example 1:
PDDL Domain: ```pddl\n(define (domain block-stacking)\n  (:requirements :strips :typing :equality)\n  (:types block table)\n  (:predicates\n    (on-table ?b - block ?t - table)\n    (clear ?b - block)\n    (holding ?b - block)\n  )\n  (:action pickup\n    :parameters (?b - block ?t - table)\n    :precondition (and (clear ?b) (not (holding ?b)) (on-table ?b ?t))\n    :effect (and (holding ?b) (not (on-table ?b ?t)) (not (clear ?b)))\n  )\n  (:action putdown\n    :parameters (?b - block ?t - table)\n    :precondition (and (holding ?b) (clear ?b))\n    :effect (and (not (holding ?b)) (on-table ?b ?t) (clear ?b))\n  )\n  (:action stack\n    :parameters (?b1 - block ?b2 - block ?t - table)\n    :precondition (and (holding ?b1) (clear ?b2) (on-table ?b2 ?t))\n    :effect (and (not (holding ?b1)) (on-table ?b1 ?b2) (not (clear ?b2)))\n  )\n  (:action unstack\n    :parameters (?b1 - block ?b2 - block ?t - table)\n    :precondition (and (not (holding ?b1)) (clear ?b1) (on-table ?b1 ?b2))\n    :effect (and (holding ?b1) (not (on-table ?b1 ?b2)) (clear ?b2))\n  )\n)\n```\n\n
Natural Language Description: The robot has four actions: pickup, putdown, stack, and unstack. The domain assumes a world where there are a set of blocks that can be stacked on top of each other, an arm that can hold one block at a time, and a table where blocks can be placed.\nThe actions defined in this domain include:\npickup: allows the arm to pick up a block from the table if it is clear and the arm is empty. After the pickup action, the arm will be holding the block, and the block will no longer be on the table or clear.\nputdown: allows the arm to put down a block on the table if it is holding a block. After the putdown action, the arm will be empty, and the block will be on the table and clear.\nstack: allows the arm to stack a block on top of another block if the arm is holding the top block and the bottom block is clear. After the stack action, the arm will be empty, the top block will be on top of the bottom block, and the bottom block will no longer be clear.\nunstack: allows the arm to unstack a block from on top of another block if the arm is empty and the top block is clear. After the unstack action, the arm will be holding the top block, the top block will no longer be on top of the bottom block, and the bottom block will be clear.

Example 2:
PDDL Domain: (define (domain robot_domain)\n\n  (:requirements :strips :equality :typing)\n\n  (:types room object robot)\n\n  (:predicates\n    (in_room ?room - room ?robot - robot)\n    (carrying ?object - object ?robot - robot)\n    (object_in_room ?object - object ?room - room)\n    (gripper_free ?robot - robot)\n  )\n\n  (:action move\n    :parameters (?from_room ?to_room ?robot)\n    :precondition (and (in_room ?from_room ?robot))\n    :effect (and (in_room ?to_room ?robot) (not (in_room ?from_room ?robot)))\n  )\n\n  (:action pick\n    :parameters (?object ?room ?robot)\n    :precondition (and (object_in_room ?object ?room) (in_room ?room ?robot) (gripper_free ?robot))\n    :effect (and (carrying ?object ?robot) (not (object_in_room ?object ?room)) (not (gripper_free ?robot)))\n  )\n\n  (:action drop\n    :parameters (?object ?room ?robot)\n    :precondition (and (carrying ?object ?robot) (in_room ?room ?robot))\n    :effect (and (not (carrying ?object ?robot)) (object_in_room ?object ?room) (gripper_free ?robot))\n  )\n)\n```
Natural Language Description: You are a robot with a gripper that can move objects between different rooms.\n\nThere are three actions defined in this domain:\n\nThe move action: This action allows the robot to move from one room to another. The action has a single precondition, which is that the robot is currently in a room. The effect of this action is to move the robot to another room and to remove the fact that it is in the original room.\n\nThe pick action: This action allows the robot to pick up an object using the gripper. The action has three preconditions: (1) the object is located in a room (2) the robot is currently in the same room and (3) the gripper is free (i.e., not holding any object). The effect of this action is to update the state of the world to show that the robot is carrying the object using the gripper, the object is no longer in the room, and the gripper is no longer free.\n\nThe drop action: This action allows the robot to drop an object that it is carrying. The action has two preconditions: (1) the robot is currently carrying the object using the gripper, and (2) the robot is currently in a room. The effect of this action is to update the state of the world to show that the robot is no longer carrying the object using the gripper, the object is now located in the room, and the gripper is now free.

Example 3:
PDDL Domain: \n(define (domain Storage-Propositional)\n(:requirements :typing)\n(:types hoist surface place area - object\n    container depot - place\n    storearea transitarea - area\n    area crate - surface)\n\n(:predicates (clear ?s - storearea)\n         (in ?x - (either storearea crate) ?p - place)\n         (available ?h - hoist)\n         (lifting ?h - hoist ?c - crate)\n         (at ?h - hoist ?a - area)\n         (on ?c - crate ?s - storearea)\n         (connected ?a1 ?a2 - area)\n             (compatible ?c1 ?c2 - crate))\n\n(:action lift\n :parameters (?h - hoist ?c - crate ?a1 - storearea ?a2 - area ?p - place)\n :precondition (and (connected ?a1 ?a2) (at ?h ?a2) (available ?h)\n            (on ?c ?a1) (in ?a1 ?p))\n :effect (and (not (on ?c ?a1)) (clear ?a1)\n          (not (available ?h)) (lifting ?h ?c) (not (in ?c ?p))))\n\n(:action drop\n :parameters (?h - hoist ?c - crate ?a1 - storearea ?a2 - area ?p - place)\n :precondition (and (connected ?a1 ?a2) (at ?h ?a2) (lifting ?h ?c)\n            (clear ?a1) (in ?a1 ?p))\n :effect (and (not (lifting ?h ?c)) (available ?h)\n          (not (clear ?a1)) (on ?c ?a1) (in ?c ?p)))\n\n(:action move\n :parameters (?h - hoist ?from ?to - storearea)\n :precondition (and (at ?h ?from) (clear ?to) (connected ?from ?to))\n :effect (and (not (at ?h ?from)) (at ?h ?to) (not (clear ?to)) (clear ?from)))\n\n(:action go-out\n :parameters (?h - hoist ?from - storearea ?to - transitarea)\n :precondition (and (at ?h ?from) (connected ?from ?to))\n :effect (and (not (at ?h ?from)) (at ?h ?to) (clear ?from)))\n\n(:action go-in\n :parameters (?h - hoist ?from - transitarea ?to - storearea)\n :precondition (and (at ?h ?from) (connected ?from ?to) (clear ?to))\n :effect (and (not (at ?h ?from)) (at ?h ?to) (not (clear ?to))))\n
Natural Language Description: There are five actions in the domain: "lift", "drop", "move", "go-out" and "go-in", each with their own parameters, preconditions, and effects.\n"lift" action lifts a crate using a hoist from a store area to an area that is connected to it, and places the crate in a place. The preconditions for the "lift" action require that the hoist is available, the hoist is at the destination area, the crate is on the surface in the source store area, and the source store area is in the place. The effects of the "lift" action remove the crate from the source store area, make the source area clear, make the hoist unavailable, make the hoist lifting the crate, and remove the crate from the place.\n"drop" action drops a crate from the hoist onto a surface in a store area that is connected to the area where the hoist is currently located. The preconditions for the "drop" action require that the hoist is at the destination area, the hoist is lifting the crate, the destination store area is clear, and the destination store area is in the place. The effects of the "drop" action remove the hoist lifting the crate, make the hoist available, make the destination area occupied by the crate, and make the crate in the destination store area.\n"move" action moves a hoist from one store area to another connected store area. The preconditions for the "move" action require that the hoist is in the source store area, the destination store area is clear, and the source and destination areas are connected. The effects of the "move" action remove the hoist from the source area, place the hoist in the destination area, make the source area occupied, and make the destination area clear.\n"go-out" action moves a hoist from a store area to a transit area that is connected to it. The preconditions for the "go-out" action require that the hoist is in the source store area, and the source and destination areas are connected. The effects of the "go-out" action remove the hoist from the source area, place the hoist in the transit area, and make the source area clear.\n"go-in" action moves a hoist from a transit area to a store area that is connected to it. The preconditions for the "go-in" action require that the hoist is in the transit area, the source and destination areas are connected, and the destination area is clear. The effects of the "go-in" action remove the hoist from the transit area, place the hoist in the destination store area, and make the destination store area occupied. 

Remember: You should not include any pddl domain variables in the natural language description. Only the actions and predicates should be described in detail in natural language .

Now its your turn to generate the natural language description of the domain, you have to follow the format I provided above.
PDDL Domain: {domain}
"""

problem2domain_template = """
You are provided with a PDDL problem code that represents a situation in a specific planning problem. Your task is to extract the significant details from this problem and construct a PDDL domain code. Your newly created domain should define predicates according to the states represented in the problem and describe actions that indicate possible operations within the scenario.

Instructions:
1. Ensure each predicate has a unique name and signature.
2. Delineate actions with appropriate preconditions and effects.
3. Separate individual conditions in both the action's preconditions and effects.
4. Any irrelevant information can be ignored.

Your output should include the Thought process outlining the identified predicates and actions and the resulting Domain:
Thought: 
(Predicate and their meanings go here)
(action1: explanation for action1)
...
(actionn: explanation for actionn)

Domain: The concrete PDDL code for domain.pddl
(Code in proper PDDL format goes here)

Now it's your turn to generate the domain code based on the provided problem.
The pddl problem is:{PDDL_problem_code}

The pddl domain code should be generated based on the information provided in the pddl problem code.
The pddl domain code is:
```pddl
"""


Loss_Prompt = """
You will be provided natural language description of a planning domain, and its corresponding pddl domain code with intermediate thought explaining each predicates and actions. 

You task is to generate critical feedback on the pddl domain code based on the natural language description. You should evaluate the grammar and logic of the pddl domain codes.

Remember: You do not solve problems or propose new code snippets, only evaluate the grammar and logic of the pddl domain codes!!!

Template:
1. Clearly check the grammar and logic of each predicates and actions in the pddl domain code.
2. Do you think the code is correct? If not, what is the problem?
3. Provide a detailed explanation of the issues you found in the pddl domain code.

Now its your turn to evaluate the pddl domain code based on the natural language description provided.
NL Description: {NL_Description}
PDDL Domain: {PDDL_Domain}
"""

GD_Prompt = """
You will be provided a PDDL domain code and critical feedback on the pddl domain code based on the natural language description.
Your task is to generate a new PDDL domain code that is more consistent with the natural language description.

Remember: You are only responsible for domain generation.
Template is:

### Thought:
predicates1: the error of predicate1, how to correct it
...
predicaten: the error of predicaten, how to correct it
action1: the error of action1, how to correct it
...
actionn: the error of action, how to correct it
<thought>

### Domain:
```pddl
The correct pddl code for domain.pddl 

Now its your time to generate the solution, you have to follow the format I provided above.
PDDL Domain: {PDDL_Domain}
Errors of PDDL Domain: {Error}
"""


Domain2NL_template_new = """
Your task is to translate the given pddl domain to its corresponding natural language description. You will be provided with the pddl domain code, and you need to generate a natural language description that captures the essence of the domain.

Here are some examples of how to translate pddl domain code to natural language:
Example 1:
PDDL Domain: ```
(define (domain termes)
(:requirements :typing :negative-preconditions)
(:types
    numb - object
    position - object
)
(:predicates
    (height ?p - position ?h - numb)
    (at ?p - position)
    (has-block)
    ;
    ; static predicates
    (SUCC ?n1 - numb ?n2 - numb)
    (NEIGHBOR ?p1 - position ?p2 - position)
    (IS-DEPOT ?p - position)
)
(:action move
    :parameters (?from - position ?to - position ?h - numb)
    :precondition
    (and
        (at ?from)
        (NEIGHBOR ?from ?to)
        (height ?from ?h)
        (height ?to ?h)
    )
    :effect
    (and
        (not (at ?from))
        (at ?to)
    )
)

(:action move-up
    :parameters (?from - position ?hfrom - numb ?to - position ?hto - numb)
    :precondition
    (and
        (at ?from)
        (NEIGHBOR ?from ?to)
        (height ?from ?hfrom)
        (height ?to ?hto)
        (SUCC ?hto ?hfrom)
    )
    :effect
    (and
        (not (at ?from))
        (at ?to)
    )
)

(:action move-down
    :parameters (?from - position ?hfrom - numb ?to - position ?hto - numb)
    :precondition
    (and
        (at ?from)
        (NEIGHBOR ?from ?to)
        (height ?from ?hfrom)
        (height ?to ?hto)
        (SUCC ?hfrom ?hto)
    )
    :effect
    (and
        (not (at ?from))
        (at ?to)
    )
)

(:action place-block
    :parameters (?rpos - position ?bpos - position ?hbefore - numb ?hafter - numb)
    :precondition
    (and
        (at ?rpos)
        (NEIGHBOR ?rpos ?bpos)
        (height ?rpos ?hbefore)
        (height ?bpos ?hbefore)
        (SUCC ?hafter ?hbefore)
        (has-block)
        (not (IS-DEPOT ?bpos))
    )
    :effect
    (and
        (not (height ?bpos ?hbefore))
        (height ?bpos ?hafter)
        (not (has-block))
    )
)

(:action remove-block
    :parameters (?rpos - position ?bpos - position ?hbefore - numb ?hafter - numb)
    :precondition
    (and
        (at ?rpos)
        (NEIGHBOR ?rpos ?bpos)
        (height ?rpos ?hafter)
        (height ?bpos ?hbefore)
        (SUCC ?hbefore ?hafter)
        (not (has-block))
    )
    :effect
    (and
        (not (height ?bpos ?hbefore))
        (height ?bpos ?hafter)
        (has-block)
    )
)

(:action create-block
    :parameters (?p - position)
    :precondition
    (and
        (at ?p)
        (not (has-block))
        (IS-DEPOT ?p)
    )
    :effect
    (and
        (has-block)
    )
)

(:action destroy-block
    :parameters (?p - position)
    :precondition
    (and
        (at ?p)
        (has-block)
        (IS-DEPOT ?p)
    )
    :effect
    (and
        (not (has-block))
    )
)

)
```
Natural Language Description: You control a robot that can take the following actions to build complex structures.

Move from a position to another. The new position and the old position must be at the same height. -- pddl action name: move

Move up from a position to another, and the height at the new position is one block higher than the old position. -- pddl action name: move-up

Move down from a position to another, and the height at the new position is one block lower than the old position. -- pddl action name: move-down

Place a block at a neighboring position from the robot's current position. The robot must have a block. The current height at the robot's position and the block's position must be the same. A block cannot be placed at the depot. The height at the block's position will be one block higher than the current height. -- pddl action name: place-block

Remove a block at a neighboring position from the robot's current position. The robot must not have a block. A block cannot be removed from the depot. The current height at the robot's position must be the same as the new height at the block's position. The new height at the block's position will be one block lower than the current height. -- pddl action name: remove-block

Create a block at the depot. The robot will have the block. -- pddl action name: create-block

Destroy a block at the depot. The robot must have a block. -- pddl action name: destroy-block

Example 2:
PDDL Domain: ```pddl
(define (domain tyreworld)
  (:types obj - object
	  tool wheel nut - obj
	  container hub - object)
(:predicates (open ?x)
             (closed ?x)
             (have ?x)
             (in ?x ?y)
             (loose ?x ?y)
             (tight ?x ?y)
             (unlocked ?x)
             (on-ground ?x)
             (not-on-ground ?x)
             (inflated ?x)
             (not-inflated ?x)
             (fastened ?x)
             (unfastened ?x)
             (free ?x)
             (on ?x ?y)
             (intact ?x))


(:action open
:parameters (?x - container)
:precondition (and (unlocked ?x) 
                   (closed ?x))
:effect (and (open ?x)
   (not (closed ?x))))

(:action close
:parameters (?x - container)
:precondition (open ?x)
:effect (and (closed ?x)
   (not (open ?x))))

(:action fetch
:parameters (?x - obj  ?y - container)
:precondition (and (in ?x ?y) (open ?y))
:effect (and (have ?x)
   (not (in ?x ?y))))

(:action put-away
:parameters (?x - obj ?y - container)
:precondition (and (have ?x) (open ?y))
:effect (and (in ?x ?y)  
   (not (have ?x))))

(:action loosen 
:parameters (?x - nut ?y - hub)
:precondition (and (have wrench) (tight ?x ?y) (on-ground ?y))
:effect (and (loose ?x ?y) 
   (not (tight ?x ?y))))

(:action tighten
:parameters (?x - nut ?y - hub)
:precondition (and (have wrench) (loose ?x ?y) (on-ground ?y))
:effect (and (tight ?x ?y) 
   (not (loose ?x ?y))))

(:action jack-up
:parameters (?y - hub)
:precondition (and (on-ground ?y) (have jack))
:effect (and (not-on-ground ?y) 
   (not (on-ground ?y))  (not (have jack))))

(:action jack-down
:parameters (?y - hub)
:precondition (not-on-ground ?y)
:effect (and (on-ground ?y)  (have jack)
   (not (not-on-ground ?y))))

(:action undo
:parameters (?x - nut ?y - hub)
:precondition (and (not-on-ground ?y) (fastened ?y) (have wrench) (loose ?x ?y))
:effect (and (have ?x) (unfastened ?y) 
   (not (fastened ?y)) (not (loose ?x ?y))))

(:action do-up
:parameters (?x - nut ?y - hub)
:precondition (and (have wrench) (unfastened ?y) (not-on-ground ?y) (have ?x))
:effect (and (loose ?x ?y) (fastened ?y) 
   (not (unfastened ?y)) (not (have ?x))))

(:action remove-wheel
:parameters (?x - wheel ?y - hub)
:precondition (and (not-on-ground ?y) (on ?x ?y) (unfastened ?y))
:effect (and (have ?x) (free ?y) 
   (not (on ?x ?y))))

(:action put-on-wheel
:parameters (?x - wheel ?y - hub)
:precondition (and (have ?x) (free ?y) (unfastened ?y) (not-on-ground ?y))
:effect (and (on ?x ?y) 
   (not (free ?y)) (not (have ?x))))

(:action inflate
:parameters (?x - wheel)
:precondition (and (have pump) (not-inflated ?x) (intact ?x))
:effect (and (inflated ?x)
   (not (not-inflated ?x)))))

Natural Language Description: Your goal is to replace flat tyres with intact tyres on the hubs. Intact tyres should be inflated. The nuts should be tight on the hubs. The flat tyres, wrench, jack, and pump should be in the boot. The boot should be closed.

There are 13 actions defined in this domain:

"open" action: The precondition for this action is that the container is unlocked and closed. The effect of this action is that the container is open and not closed.

"close" action: The precondition for this action is that the container is open. The effect of this action is that the container is closed and not open.

"fetch" action: The precondition for this action is that the object is inside the container and the container is open. The effect of this action is that the object is held by the agent and not inside the container.

"put-away" action: The precondition for this action is that the object is held by the agent and the container is open. The effect of this action is that the object is inside the container and not held by the agent.

"loosen" action: The precondition for this action is that the agent has a wrench, the nut on hub is tight, and the hub is on the ground. The effect of this action is that the nut on hub is loose and not tight.

"tighten" action: The precondition for this action is that the agent has a wrench, the nut on hub is loose, and the hub is on the ground. The effect of this action is that the nut on hub is tight and not loose.

"jack-up" action: This action represents the process of lifting a hub off the ground using a jack. It requires the agent to have a jack and for the hub to be on the ground. After performing this action, the hub will no longer be on the ground and the agent will no longer have the jack.

"jack-down" action: This action represents the process of lowering a hub back to the ground from an elevated position using a jack. It requires the agent to have the hub off the ground. After performing this action, the hub will be back on the ground and the agent will have the jack.

"undo" action: This action undo the fastening of a nut on a hub. The preconditions are the hub is not on the ground (i.e., it has been jacked up), the hub is fastened, the agent has a wrench and the nut is loose. The effects are the agent has the nut, the hub is unfastened, the hub is no longer loose and the hub is not fastened anymore.

"do-up" action: This action fasten a nut on a hub. The preconditions are the agent has a wrench, the hub is unfastened, the hub is not on the ground (i.e., it has been jacked up) and the agent has the nut to be fastened. The effects are the nut is now loose on the hub, the hub is fastened, the hub is no longer unfastened and the agent no longer has the nut.

"remove-wheel" action: This action removes a wheel from a hub. It can only be performed if the hub is not on the ground, the wheel is currently on the hub, and the hub is unfastened. After the action is performed, the agent will have the removed wheel and the hub will be free, meaning that the wheel is no longer on the hub.

"put-on-wheel" action: This action puts a wheel onto a hub. It can only be performed if the agent has the wheel, the hub is free, the hub is unfastened, and the hub is not on the ground. After the action is performed, the wheel will be on the hub, the hub will no longer be free, and the agent will no longer have the wheel.

"inflate" action: This action inflates a wheel using a pump. It can only be performed if the agent has a pump, the wheel is not inflated, and the wheel is intact. After the action is performed, the wheel will be inflated.

Remember: You should not include any pddl domain variables except action name in the natural language description. Only the actions and predicates should be described in detail in natural language .

Now its your turn to generate the natural language description of the domain, you have to follow the format I provided above.
PDDL Domain: {domain}
"""