#!/bin/bash

for file in /lustre/fast/fast/txiao/zly/spatial_head/cot/result/case_study/case_N/*; do
    # 构建输入文件路径
    input_file="$file"
    # 提取文件名的最后一个部分
    file_name=$(basename "$file")
    # 构建输出文件路径，将文件移动到 /lustre/fast/fast/txiao/zly/spatial_head/cot/result/Val 目录下，并保留原文件名的最后一个部分
    output_file="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Val/case_study/case_N/$file_name"
    
    # 调用 Python 脚本处理文件
    python /lustre/fast/fast/txiao/zly/spatial_head/cot/validate_domain_rollout.py --input_file "$input_file" --output_file "$output_file"
done

python3 /lustre/fast/fast/txiao/zly/spatial_head/cot/plot/visual_val.py --input_dir "/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Val/case_study/case_N/"  --image_path "/lustre/fast/fast/txiao/zly/spatial_head/cot/plot/table/case_N.png" --out_path "/lustre/fast/fast/txiao/zly/spatial_head/cot/plot/table/case_N.csv"
