#!/bin/bash
source ~/miniconda3/etc/profile.d/conda.sh
conda activate autoformalization

model_path='/lustre/fast/fast/txiao/zly/ckpt/Qwen25Coder7B'
nl_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/domain_nl.json"
prob_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/question_all.json"
nl_result_path='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/vml_exp/nl_'
prob_result_path='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/vml_exp/prob_'
worst_init_path_nl='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/baseline_domain_gen/nl_Qwen25Coder7B.json'
worst_init_path_prob='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/baseline_domain_gen/prob_Qwen25Coder7B.json'
mid_init_path_nl='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/coder1_nl.json'
mid_init_path_prob='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/coder1_prob.json'
best_init_path_nl='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/coder4_nl.json'
best_init_path_prob='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/Domain_gen/coder4_prob.json'


epoches=(30)
nl_input_paths=($worst_init_path_nl $mid_init_path_nl $best_init_path_nl)
prob_input_paths=($worst_init_path_prob $mid_init_path_prob $best_init_path_prob)
cd /lustre/fast/fast/txiao/zly/spatial_head/cot
for epoch in ${epoches[@]}; do
    for nl_input_path in ${nl_input_paths[@]}; do
        output_path="${nl_result_path}${epoch}${nl_input_path##*/}"
        python textgrad_batch_new.py --model_path $model_path --input_data $nl_input_path --output_path $output_path --epoch $epoch
    done
done


