#!/bin/bash
source ~/miniconda3/etc/profile.d/conda.sh
conda activate autoformalization


sampling_nums=(16)
epoch=5
input_data_dir='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/case_study'
output_data_dir='/lustre/fast/fast/txiao/zly/spatial_head/cot/result/GradientD'
for sampling_num in ${sampling_nums[@]}
do
    input_data="${input_data_dir}/case_N2/case_pddl_${sampling_num}.json"
    output_path="${output_data_dir}/case_pddl_${sampling_num}_GD_epoch${epoch}.json"
    python /lustre/fast/fast/txiao/zly/spatial_head/cot/textgrad_batch_new.py  --input_data $input_data --output_path $output_path --epoch $epoch 
done
