#!/bin/bash
source ~/miniconda3/etc/profile.d/conda.sh
conda activate autoformalization


data_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/case_study/domain_case.json"
output_path_case_base="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/case_study/case_pddl"
n_SamplingParams=(1 2 4 8 16 32 64)


for n_SamplingParam in ${n_SamplingParams[@]}; do
    output_path_case="${output_path_case_base}_${n_SamplingParam}.json"
    python /lustre/fast/fast/txiao/zly/spatial_head/cot/rollout.py \
        --data_path $data_path \
        --output_path $output_path_case \
        --n_SamplingParams $n_SamplingParam \
        --model_name /lustre/fast/fast/txiao/zly/ckpt/Qwen25Coder7B
done

