#!/bin/bash
source ~/miniconda3/etc/profile.d/conda.sh
conda activate autoformalization

nl_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/domain_nl.json"
prob_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/question_all.json"
nl_result_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/rollout_param/nl_"
prob_result_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/rollout_param/prob_"
Model_DIR="/lustre/fast/fast/txiao/zly/ckpt/"
n_SamplingParams=(128 100 64 48 32 16 8 4 2)
model_candidates=("Llama-3.1-8B-Instruct" "Llama-3.1-70B-Instruct")
# for model in $(ls $Model_DIR); do
#     if [[ $model == *"Qwen2.5-"* ]]; then
#         output_path="${nl_result_path}${model}.json"
#         python rollout.py --model_name "${Model_DIR}${model}" --tokenizer_name "${Model_DIR}${model}" --data_path "${nl_path}" --output_path "$output_path" --n_SamplingParams 8
#     fi
# done

# for model in $(ls $Model_DIR); do
#     if [[ $model == *"Qwen2.5-"* ]]; then
#         output_path="${prob_result_path}${model}.json"
#         python rollout.py --model_name "${Model_DIR}${model}" --tokenizer_name "${Model_DIR}${model}" --data_path "${prob_path}" --output_path "$output_path" --n_SamplingParams 8
#     fi
# done
cd /lustre/fast/fast/txiao/zly/spatial_head/cot
for model in ${model_candidates[@]}; do
    for n_SamplingParam in ${n_SamplingParams[@]}; do
        output_path="${nl_result_path}${model}_${n_SamplingParam}_1129.json"
        python rollout.py --model_name "${Model_DIR}${model}" --tokenizer_name "${Model_DIR}${model}${n_SamplingParam}" --data_path "${nl_path}" --output_path "$output_path" --n_SamplingParams $n_SamplingParam
    done
done

for model in ${model_candidates[@]}; do
    for n_SamplingParam in ${n_SamplingParams[@]}; do
        output_path="${prob_result_path}${model}_${n_SamplingParam}_1129.json"
        python rollout.py --model_name "${Model_DIR}${model}" --tokenizer_name "${Model_DIR}${model}${n_SamplingParam}" --data_path "${prob_path}" --output_path "$output_path" --n_SamplingParams $n_SamplingParam
    done
done