#!/bin/bash
source ~/miniconda3/etc/profile.d/conda.sh
conda activate autoformalization

prob_data="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/question_all.json"
prob_output_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/baseline_domain_gen/prob_"

nl_data="/lustre/fast/fast/txiao/zly/spatial_head/cot/benchmark/ipc_bench/domain_nl.json"
nl_output_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/baseline_domain_gen/nl_"
baseline_path="/lustre/fast/fast/txiao/zly/spatial_head/cot/result/baseline_domain_gen/"
Model_DIR="/lustre/fast/fast/txiao/zly/ckpt/"

# for every model in Model_DIR
for model in $(ls $Model_DIR); do
    if [[ $model == *"Qwen25Coder7B"* ]]; then
        # run the model on the input data
        output_path="${nl_output_path}${model}.json"
        python /lustre/fast/fast/txiao/zly/spatial_head/cot/baselines/qwen_baseline_domaingen.py --model_dir $Model_DIR$model --input_file $nl_data --output_file $output_path
    fi
done

# for model in $(ls $Model_DIR); do
#     # if the model name contains "LLama3.1" 
#     if [[ $model == *"Llama-3.1"* ]]; then
#         # run the model on the input data
#         output_path="${prob_output_path}${model}.json"
#         python /lustre/fast/fast/txiao/zly/spatial_head/cot/baselines/llama_baseline_prob.py --model_dir $Model_DIR$model --input_file $prob_data --output_file $output_path
#     fi
# done

# for every model in Model_DIR
# for model in $(ls $Model_DIR); do
#     # if the model name contains "LLama3.1" 
#     if [[ $model == *"Llama-3.1"* ]]; then
#         # run the model on the input data
#         output_path="${nl_output_path}${model}.json"
#         python /lustre/fast/fast/txiao/zly/spatial_head/cot/baselines/llama_baseline_domaingen.py --model_dir $Model_DIR$model --input_file $nl_data --output_file $output_path
#     fi
# done

# for every model in Model_DIR
for model in $(ls $Model_DIR); do
    # if the model name contains "LLama3.1" 
    if [[ $model == *"Qwen25Coder7B"* ]]; then
        # run the model on the input data
        output_path="${prob_output_path}${model}.json"
        # the model_dir should be the model_dir 
        # --model_dir $Model_DIR{$model}
        python /lustre/fast/fast/txiao/zly/spatial_head/cot/baselines/qwen_baseline_question.py --model_dir $Model_DIR$model --input_file $prob_data --output_file $output_path
    fi
done

